@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
 */
public enum class WindowsPatchAssessmentMode(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.WindowsPatchAssessmentMode,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.WindowsPatchAssessmentMode> {
    ImageDefault(com.pulumi.azurenative.azurefleet.enums.WindowsPatchAssessmentMode.ImageDefault),
    AutomaticByPlatform(com.pulumi.azurenative.azurefleet.enums.WindowsPatchAssessmentMode.AutomaticByPlatform),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.WindowsPatchAssessmentMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.WindowsPatchAssessmentMode): WindowsPatchAssessmentMode =
            WindowsPatchAssessmentMode.values().first { it.javaValue == javaType }
    }
}
