@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
 */
public enum class WindowsVMGuestPatchMode(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode> {
    Manual(com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode.Manual),
    AutomaticByOS(com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode.AutomaticByOS),
    AutomaticByPlatform(com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode.AutomaticByPlatform),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.WindowsVMGuestPatchMode): WindowsVMGuestPatchMode =
            WindowsVMGuestPatchMode.values().first { it.javaValue == javaType }
    }
}
