@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.BootDiagnosticsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
 * @property enabled Whether boot diagnostics should be enabled on the Virtual Machine.
 * @property storageUri Uri of the storage account to use for placing the console output and screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
 */
public data class BootDiagnosticsArgs(
    public val enabled: Output<Boolean>? = null,
    public val storageUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.BootDiagnosticsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.BootDiagnosticsArgs =
        com.pulumi.azurenative.azurefleet.inputs.BootDiagnosticsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .storageUri(storageUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BootDiagnosticsArgs].
 */
@PulumiTagMarker
public class BootDiagnosticsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var storageUri: Output<String>? = null

    /**
     * @param value Whether boot diagnostics should be enabled on the Virtual Machine.
     */
    @JvmName("nmgrsnlvjbbswkqe")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Uri of the storage account to use for placing the console output and screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
     */
    @JvmName("tqjktsbdkuupyvyg")
    public suspend fun storageUri(`value`: Output<String>) {
        this.storageUri = value
    }

    /**
     * @param value Whether boot diagnostics should be enabled on the Virtual Machine.
     */
    @JvmName("lwukaoxpdwcqweoc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Uri of the storage account to use for placing the console output and screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
     */
    @JvmName("hmywspnbbpwexlmy")
    public suspend fun storageUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageUri = mapped
    }

    internal fun build(): BootDiagnosticsArgs = BootDiagnosticsArgs(
        enabled = enabled,
        storageUri = storageUri,
    )
}
