@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.CapacityReservationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The parameters of a capacity reservation Profile.
 * @property capacityReservationGroup Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.
 */
public data class CapacityReservationProfileArgs(
    public val capacityReservationGroup: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.CapacityReservationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.CapacityReservationProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.CapacityReservationProfileArgs.builder()
            .capacityReservationGroup(
                capacityReservationGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CapacityReservationProfileArgs].
 */
@PulumiTagMarker
public class CapacityReservationProfileArgsBuilder internal constructor() {
    private var capacityReservationGroup: Output<SubResourceArgs>? = null

    /**
     * @param value Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.
     */
    @JvmName("xwfcuihlgdishcle")
    public suspend fun capacityReservationGroup(`value`: Output<SubResourceArgs>) {
        this.capacityReservationGroup = value
    }

    /**
     * @param value Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.
     */
    @JvmName("xushnpxkilxfaiyi")
    public suspend fun capacityReservationGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationGroup = mapped
    }

    /**
     * @param argument Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.
     */
    @JvmName("tajwulmmqonocbyj")
    public suspend fun capacityReservationGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationGroup = mapped
    }

    internal fun build(): CapacityReservationProfileArgs = CapacityReservationProfileArgs(
        capacityReservationGroup = capacityReservationGroup,
    )
}
