@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.ComputeProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Compute Profile to use for running user's workloads.
 * @property baseVirtualMachineProfile Base Virtual Machine Profile Properties to be specified according to "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile"
 * @property computeApiVersion Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machine scale sets and Virtual Machines.
 * The default value will be the latest supported computeApiVersion by Compute Fleet.
 * @property platformFaultDomainCount Specifies the number of fault domains to use when creating the underlying VMSS.
 * A fault domain is a logical group of hardware within an Azure datacenter.
 * VMs in the same fault domain share a common power source and network switch.
 * If not specified, defaults to 1, which represents "Max Spreading" (using as many fault domains as possible).
 * This property cannot be updated.
 */
public data class ComputeProfileArgs(
    public val baseVirtualMachineProfile: Output<VirtualMachineScaleSetVMProfileArgs>,
    public val computeApiVersion: Output<String>? = null,
    public val platformFaultDomainCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.ComputeProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.ComputeProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.ComputeProfileArgs.builder()
            .baseVirtualMachineProfile(
                baseVirtualMachineProfile.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .computeApiVersion(computeApiVersion?.applyValue({ args0 -> args0 }))
            .platformFaultDomainCount(platformFaultDomainCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeProfileArgs].
 */
@PulumiTagMarker
public class ComputeProfileArgsBuilder internal constructor() {
    private var baseVirtualMachineProfile: Output<VirtualMachineScaleSetVMProfileArgs>? = null

    private var computeApiVersion: Output<String>? = null

    private var platformFaultDomainCount: Output<Int>? = null

    /**
     * @param value Base Virtual Machine Profile Properties to be specified according to "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile"
     */
    @JvmName("vopjrqgvbjklmava")
    public suspend fun baseVirtualMachineProfile(`value`: Output<VirtualMachineScaleSetVMProfileArgs>) {
        this.baseVirtualMachineProfile = value
    }

    /**
     * @param value Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machine scale sets and Virtual Machines.
     * The default value will be the latest supported computeApiVersion by Compute Fleet.
     */
    @JvmName("tdsluscnyyqahupu")
    public suspend fun computeApiVersion(`value`: Output<String>) {
        this.computeApiVersion = value
    }

    /**
     * @param value Specifies the number of fault domains to use when creating the underlying VMSS.
     * A fault domain is a logical group of hardware within an Azure datacenter.
     * VMs in the same fault domain share a common power source and network switch.
     * If not specified, defaults to 1, which represents "Max Spreading" (using as many fault domains as possible).
     * This property cannot be updated.
     */
    @JvmName("npiwjpgskebugvtu")
    public suspend fun platformFaultDomainCount(`value`: Output<Int>) {
        this.platformFaultDomainCount = value
    }

    /**
     * @param value Base Virtual Machine Profile Properties to be specified according to "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile"
     */
    @JvmName("yxibfrualedefuoe")
    public suspend fun baseVirtualMachineProfile(`value`: VirtualMachineScaleSetVMProfileArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseVirtualMachineProfile = mapped
    }

    /**
     * @param argument Base Virtual Machine Profile Properties to be specified according to "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile"
     */
    @JvmName("yafhhlfrrxbdvlld")
    public suspend fun baseVirtualMachineProfile(argument: suspend VirtualMachineScaleSetVMProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetVMProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.baseVirtualMachineProfile = mapped
    }

    /**
     * @param value Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machine scale sets and Virtual Machines.
     * The default value will be the latest supported computeApiVersion by Compute Fleet.
     */
    @JvmName("whrtvnmhrrwvgxyg")
    public suspend fun computeApiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeApiVersion = mapped
    }

    /**
     * @param value Specifies the number of fault domains to use when creating the underlying VMSS.
     * A fault domain is a logical group of hardware within an Azure datacenter.
     * VMs in the same fault domain share a common power source and network switch.
     * If not specified, defaults to 1, which represents "Max Spreading" (using as many fault domains as possible).
     * This property cannot be updated.
     */
    @JvmName("nvppvymnbitykdyv")
    public suspend fun platformFaultDomainCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformFaultDomainCount = mapped
    }

    internal fun build(): ComputeProfileArgs = ComputeProfileArgs(
        baseVirtualMachineProfile = baseVirtualMachineProfile ?: throw
            PulumiNullFieldException("baseVirtualMachineProfile"),
        computeApiVersion = computeApiVersion,
        platformFaultDomainCount = platformFaultDomainCount,
    )
}
