@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.DiagnosticsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property bootDiagnostics Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
 */
public data class DiagnosticsProfileArgs(
    public val bootDiagnostics: Output<BootDiagnosticsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.DiagnosticsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.DiagnosticsProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.DiagnosticsProfileArgs.builder()
            .bootDiagnostics(
                bootDiagnostics?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DiagnosticsProfileArgs].
 */
@PulumiTagMarker
public class DiagnosticsProfileArgsBuilder internal constructor() {
    private var bootDiagnostics: Output<BootDiagnosticsArgs>? = null

    /**
     * @param value Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
     */
    @JvmName("jerciuaddpimyocc")
    public suspend fun bootDiagnostics(`value`: Output<BootDiagnosticsArgs>) {
        this.bootDiagnostics = value
    }

    /**
     * @param value Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
     */
    @JvmName("nqmmeuwegjvrirvx")
    public suspend fun bootDiagnostics(`value`: BootDiagnosticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootDiagnostics = mapped
    }

    /**
     * @param argument Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
     */
    @JvmName("tcpbnqmacqmdjoqw")
    public suspend fun bootDiagnostics(argument: suspend BootDiagnosticsArgsBuilder.() -> Unit) {
        val toBeMapped = BootDiagnosticsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bootDiagnostics = mapped
    }

    internal fun build(): DiagnosticsProfileArgs = DiagnosticsProfileArgs(
        bootDiagnostics = bootDiagnostics,
    )
}
