@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.DiskEncryptionSetParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
 * @property id Resource Id
 */
public data class DiskEncryptionSetParametersArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.DiskEncryptionSetParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.DiskEncryptionSetParametersArgs =
        com.pulumi.azurenative.azurefleet.inputs.DiskEncryptionSetParametersArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskEncryptionSetParametersArgs].
 */
@PulumiTagMarker
public class DiskEncryptionSetParametersArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource Id
     */
    @JvmName("ejpsnbcadeebwyjv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("vffwhxerqhjqsmlt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): DiskEncryptionSetParametersArgs = DiskEncryptionSetParametersArgs(
        id = id,
    )
}
