@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.EncryptionIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the Managed Identity used by ADE to get access token for keyvault operations.
 * @property userAssignedIdentityResourceId Specifies ARM Resource ID of one of the user identities associated with the VM.
 */
public data class EncryptionIdentityArgs(
    public val userAssignedIdentityResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.EncryptionIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.EncryptionIdentityArgs =
        com.pulumi.azurenative.azurefleet.inputs.EncryptionIdentityArgs.builder()
            .userAssignedIdentityResourceId(
                userAssignedIdentityResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EncryptionIdentityArgs].
 */
@PulumiTagMarker
public class EncryptionIdentityArgsBuilder internal constructor() {
    private var userAssignedIdentityResourceId: Output<String>? = null

    /**
     * @param value Specifies ARM Resource ID of one of the user identities associated with the VM.
     */
    @JvmName("imdimuuvwynkiknp")
    public suspend fun userAssignedIdentityResourceId(`value`: Output<String>) {
        this.userAssignedIdentityResourceId = value
    }

    /**
     * @param value Specifies ARM Resource ID of one of the user identities associated with the VM.
     */
    @JvmName("xqrxgvgnyuimyegn")
    public suspend fun userAssignedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentityResourceId = mapped
    }

    internal fun build(): EncryptionIdentityArgs = EncryptionIdentityArgs(
        userAssignedIdentityResourceId = userAssignedIdentityResourceId,
    )
}
