@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.GetFleetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fleetName The name of the Compute Fleet
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFleetPlainArgs(
    public val fleetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.GetFleetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.GetFleetPlainArgs =
        com.pulumi.azurenative.azurefleet.inputs.GetFleetPlainArgs.builder()
            .fleetName(fleetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFleetPlainArgs].
 */
@PulumiTagMarker
public class GetFleetPlainArgsBuilder internal constructor() {
    private var fleetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Compute Fleet
     */
    @JvmName("ciwisfhmcuyybpex")
    public suspend fun fleetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fleetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fpnepouvdhewadbm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFleetPlainArgs = GetFleetPlainArgs(
        fleetName = fleetName ?: throw PulumiNullFieldException("fleetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
