@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.KeyVaultSecretReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a reference to Key Vault Secret
 * @property secretUrl The URL referencing a secret in a Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing the secret.
 */
public data class KeyVaultSecretReferenceArgs(
    public val secretUrl: Output<String>,
    public val sourceVault: Output<SubResourceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.KeyVaultSecretReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.KeyVaultSecretReferenceArgs =
        com.pulumi.azurenative.azurefleet.inputs.KeyVaultSecretReferenceArgs.builder()
            .secretUrl(secretUrl.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultSecretReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultSecretReferenceArgsBuilder internal constructor() {
    private var secretUrl: Output<String>? = null

    private var sourceVault: Output<SubResourceArgs>? = null

    /**
     * @param value The URL referencing a secret in a Key Vault.
     */
    @JvmName("iiglxvcnktafsvdd")
    public suspend fun secretUrl(`value`: Output<String>) {
        this.secretUrl = value
    }

    /**
     * @param value The relative URL of the Key Vault containing the secret.
     */
    @JvmName("mkuxjcypnolmiajp")
    public suspend fun sourceVault(`value`: Output<SubResourceArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value The URL referencing a secret in a Key Vault.
     */
    @JvmName("pyllewscwekqsacc")
    public suspend fun secretUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretUrl = mapped
    }

    /**
     * @param value The relative URL of the Key Vault containing the secret.
     */
    @JvmName("jsiabybdqicstpcw")
    public suspend fun sourceVault(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument The relative URL of the Key Vault containing the secret.
     */
    @JvmName("ebxdorlhvlmuvjdp")
    public suspend fun sourceVault(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): KeyVaultSecretReferenceArgs = KeyVaultSecretReferenceArgs(
        secretUrl = secretUrl ?: throw PulumiNullFieldException("secretUrl"),
        sourceVault = sourceVault ?: throw PulumiNullFieldException("sourceVault"),
    )
}
