@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.LinuxVMGuestPatchAutomaticByPlatformRebootSetting
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies additional settings to be applied when patch mode AutomaticByPlatform is selected in Linux patch settings.
 * @property bypassPlatformSafetyChecksOnUserSchedule Enables customer to schedule patching without accidental upgrades
 * @property rebootSetting Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
 */
public data class LinuxVMGuestPatchAutomaticByPlatformSettingsArgs(
    public val bypassPlatformSafetyChecksOnUserSchedule: Output<Boolean>? = null,
    public val rebootSetting: Output<Either<String, LinuxVMGuestPatchAutomaticByPlatformRebootSetting>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs =
        com.pulumi.azurenative.azurefleet.inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs.builder()
            .bypassPlatformSafetyChecksOnUserSchedule(
                bypassPlatformSafetyChecksOnUserSchedule?.applyValue({ args0 ->
                    args0
                }),
            )
            .rebootSetting(
                rebootSetting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LinuxVMGuestPatchAutomaticByPlatformSettingsArgs].
 */
@PulumiTagMarker
public class LinuxVMGuestPatchAutomaticByPlatformSettingsArgsBuilder internal constructor() {
    private var bypassPlatformSafetyChecksOnUserSchedule: Output<Boolean>? = null

    private var rebootSetting:
        Output<Either<String, LinuxVMGuestPatchAutomaticByPlatformRebootSetting>>? = null

    /**
     * @param value Enables customer to schedule patching without accidental upgrades
     */
    @JvmName("yvsneelalxuqofke")
    public suspend fun bypassPlatformSafetyChecksOnUserSchedule(`value`: Output<Boolean>) {
        this.bypassPlatformSafetyChecksOnUserSchedule = value
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("haqdbbbdefrksgbp")
    public suspend fun rebootSetting(`value`: Output<Either<String, LinuxVMGuestPatchAutomaticByPlatformRebootSetting>>) {
        this.rebootSetting = value
    }

    /**
     * @param value Enables customer to schedule patching without accidental upgrades
     */
    @JvmName("trdybrlrqvgyoyum")
    public suspend fun bypassPlatformSafetyChecksOnUserSchedule(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPlatformSafetyChecksOnUserSchedule = mapped
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("lchmbtjcbatirkus")
    public suspend fun rebootSetting(`value`: Either<String, LinuxVMGuestPatchAutomaticByPlatformRebootSetting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("bfwiylbhhccxtabp")
    public fun rebootSetting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LinuxVMGuestPatchAutomaticByPlatformRebootSetting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("ddrfbuyuuvwhydlo")
    public fun rebootSetting(`value`: LinuxVMGuestPatchAutomaticByPlatformRebootSetting) {
        val toBeMapped = Either.ofRight<
            String,
            LinuxVMGuestPatchAutomaticByPlatformRebootSetting,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    internal fun build(): LinuxVMGuestPatchAutomaticByPlatformSettingsArgs =
        LinuxVMGuestPatchAutomaticByPlatformSettingsArgs(
            bypassPlatformSafetyChecksOnUserSchedule = bypassPlatformSafetyChecksOnUserSchedule,
            rebootSetting = rebootSetting,
        )
}
