@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.PatchSettingsArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.WindowsPatchAssessmentMode
import com.pulumi.azurenative.azurefleet.kotlin.enums.WindowsVMGuestPatchMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies settings related to VM Guest Patching on Windows.
 * @property assessmentMode Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
 * @property automaticByPlatformSettings Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.
 * @property enableHotpatching Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
 * @property patchMode Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
 */
public data class PatchSettingsArgs(
    public val assessmentMode: Output<Either<String, WindowsPatchAssessmentMode>>? = null,
    public val automaticByPlatformSettings: Output<WindowsVMGuestPatchAutomaticByPlatformSettingsArgs>? = null,
    public val enableHotpatching: Output<Boolean>? = null,
    public val patchMode: Output<Either<String, WindowsVMGuestPatchMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.PatchSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.PatchSettingsArgs =
        com.pulumi.azurenative.azurefleet.inputs.PatchSettingsArgs.builder()
            .assessmentMode(
                assessmentMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .automaticByPlatformSettings(
                automaticByPlatformSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enableHotpatching(enableHotpatching?.applyValue({ args0 -> args0 }))
            .patchMode(
                patchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PatchSettingsArgs].
 */
@PulumiTagMarker
public class PatchSettingsArgsBuilder internal constructor() {
    private var assessmentMode: Output<Either<String, WindowsPatchAssessmentMode>>? = null

    private var automaticByPlatformSettings:
        Output<WindowsVMGuestPatchAutomaticByPlatformSettingsArgs>? = null

    private var enableHotpatching: Output<Boolean>? = null

    private var patchMode: Output<Either<String, WindowsVMGuestPatchMode>>? = null

    /**
     * @param value Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("pelyjsnypoxurrhu")
    public suspend fun assessmentMode(`value`: Output<Either<String, WindowsPatchAssessmentMode>>) {
        this.assessmentMode = value
    }

    /**
     * @param value Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.
     */
    @JvmName("akmltcpsdrrffnfx")
    public suspend fun automaticByPlatformSettings(`value`: Output<WindowsVMGuestPatchAutomaticByPlatformSettingsArgs>) {
        this.automaticByPlatformSettings = value
    }

    /**
     * @param value Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
     */
    @JvmName("xblupxbgnlvprrmx")
    public suspend fun enableHotpatching(`value`: Output<Boolean>) {
        this.enableHotpatching = value
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
     */
    @JvmName("iukdfnvnweialvde")
    public suspend fun patchMode(`value`: Output<Either<String, WindowsVMGuestPatchMode>>) {
        this.patchMode = value
    }

    /**
     * @param value Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("pfwpjgrhyqlxfnsh")
    public suspend fun assessmentMode(`value`: Either<String, WindowsPatchAssessmentMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("lqffxeftbliqkdig")
    public fun assessmentMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WindowsPatchAssessmentMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
     */
    @JvmName("kgiybryfsxximnem")
    public fun assessmentMode(`value`: WindowsPatchAssessmentMode) {
        val toBeMapped = Either.ofRight<String, WindowsPatchAssessmentMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.
     */
    @JvmName("ddtvflpfyuxvdhbf")
    public suspend fun automaticByPlatformSettings(`value`: WindowsVMGuestPatchAutomaticByPlatformSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticByPlatformSettings = mapped
    }

    /**
     * @param argument Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.
     */
    @JvmName("dqerognbwkdveipq")
    public suspend fun automaticByPlatformSettings(argument: suspend WindowsVMGuestPatchAutomaticByPlatformSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsVMGuestPatchAutomaticByPlatformSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.automaticByPlatformSettings = mapped
    }

    /**
     * @param value Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
     */
    @JvmName("sinhoabhsmofjisy")
    public suspend fun enableHotpatching(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHotpatching = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
     */
    @JvmName("huehprskfxppkudt")
    public suspend fun patchMode(`value`: Either<String, WindowsVMGuestPatchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
     */
    @JvmName("tbxvgdhmtbkmjfvx")
    public fun patchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WindowsVMGuestPatchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    /**
     * @param value Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true
     */
    @JvmName("bhnqmqxolsiybooy")
    public fun patchMode(`value`: WindowsVMGuestPatchMode) {
        val toBeMapped = Either.ofRight<String, WindowsVMGuestPatchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    internal fun build(): PatchSettingsArgs = PatchSettingsArgs(
        assessmentMode = assessmentMode,
        automaticByPlatformSettings = automaticByPlatformSettings,
        enableHotpatching = enableHotpatching,
        patchMode = patchMode,
    )
}
