@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.ProxyAgentSettingsArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.Mode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies ProxyAgent settings while creating the virtual machine. Minimum api-version: 2023-09-01.
 * @property enabled Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.
 * @property keyIncarnationId Increase the value of this property allows user to reset the key used for securing communication channel between guest and host.
 * @property mode Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
 */
public data class ProxyAgentSettingsArgs(
    public val enabled: Output<Boolean>? = null,
    public val keyIncarnationId: Output<Int>? = null,
    public val mode: Output<Either<String, Mode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.ProxyAgentSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.ProxyAgentSettingsArgs =
        com.pulumi.azurenative.azurefleet.inputs.ProxyAgentSettingsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyIncarnationId(keyIncarnationId?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ProxyAgentSettingsArgs].
 */
@PulumiTagMarker
public class ProxyAgentSettingsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var keyIncarnationId: Output<Int>? = null

    private var mode: Output<Either<String, Mode>>? = null

    /**
     * @param value Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.
     */
    @JvmName("mjsctwhhhkhpyugu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Increase the value of this property allows user to reset the key used for securing communication channel between guest and host.
     */
    @JvmName("ubootwgcqhgjhwjv")
    public suspend fun keyIncarnationId(`value`: Output<Int>) {
        this.keyIncarnationId = value
    }

    /**
     * @param value Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
     */
    @JvmName("didottfwqtehxinu")
    public suspend fun mode(`value`: Output<Either<String, Mode>>) {
        this.mode = value
    }

    /**
     * @param value Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.
     */
    @JvmName("ymsvlanwmtvdamkg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Increase the value of this property allows user to reset the key used for securing communication channel between guest and host.
     */
    @JvmName("cpocdmyiygtyqmbl")
    public suspend fun keyIncarnationId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIncarnationId = mapped
    }

    /**
     * @param value Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
     */
    @JvmName("gjraumuxjoonwdrc")
    public suspend fun mode(`value`: Either<String, Mode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
     */
    @JvmName("eqxvlwfcuesmrbmf")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
     */
    @JvmName("qufhlafgympbkkfs")
    public fun mode(`value`: Mode) {
        val toBeMapped = Either.ofRight<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): ProxyAgentSettingsArgs = ProxyAgentSettingsArgs(
        enabled = enabled,
        keyIncarnationId = keyIncarnationId,
        mode = mode,
    )
}
