@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.RegularPriorityProfileArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.RegularPriorityAllocationStrategy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration Options for Regular instances in Compute Fleet.
 * @property allocationStrategy Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
 * @property capacity Total capacity to achieve. It is currently in terms of number of VMs.
 * @property minCapacity Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
 */
public data class RegularPriorityProfileArgs(
    public val allocationStrategy: Output<Either<String, RegularPriorityAllocationStrategy>>? = null,
    public val capacity: Output<Int>? = null,
    public val minCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.RegularPriorityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.RegularPriorityProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.RegularPriorityProfileArgs.builder()
            .allocationStrategy(
                allocationStrategy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegularPriorityProfileArgs].
 */
@PulumiTagMarker
public class RegularPriorityProfileArgsBuilder internal constructor() {
    private var allocationStrategy: Output<Either<String, RegularPriorityAllocationStrategy>>? = null

    private var capacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
     */
    @JvmName("vymnbulxvctsdbon")
    public suspend fun allocationStrategy(`value`: Output<Either<String, RegularPriorityAllocationStrategy>>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Total capacity to achieve. It is currently in terms of number of VMs.
     */
    @JvmName("cbbvghsatewskdss")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
     */
    @JvmName("kcavtdbmswiwwkkc")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
     */
    @JvmName("alnpishjrshpcyrg")
    public suspend fun allocationStrategy(`value`: Either<String, RegularPriorityAllocationStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
     */
    @JvmName("nxyyiwsxrnyyseph")
    public fun allocationStrategy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RegularPriorityAllocationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
     */
    @JvmName("hnyrlfphjqdccmyd")
    public fun allocationStrategy(`value`: RegularPriorityAllocationStrategy) {
        val toBeMapped = Either.ofRight<String, RegularPriorityAllocationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Total capacity to achieve. It is currently in terms of number of VMs.
     */
    @JvmName("lqcvqcftkwahbdwh")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
     */
    @JvmName("ytvhyamsgophiilk")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): RegularPriorityProfileArgs = RegularPriorityProfileArgs(
        allocationStrategy = allocationStrategy,
        capacity = capacity,
        minCapacity = minCapacity,
    )
}
