@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.ScheduledEventsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property osImageNotificationProfile Specifies OS Image Scheduled Event related configurations.
 * @property terminateNotificationProfile Specifies Terminate Scheduled Event related configurations.
 */
public data class ScheduledEventsProfileArgs(
    public val osImageNotificationProfile: Output<OSImageNotificationProfileArgs>? = null,
    public val terminateNotificationProfile: Output<TerminateNotificationProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.ScheduledEventsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.ScheduledEventsProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.ScheduledEventsProfileArgs.builder()
            .osImageNotificationProfile(
                osImageNotificationProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .terminateNotificationProfile(
                terminateNotificationProfile?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ScheduledEventsProfileArgs].
 */
@PulumiTagMarker
public class ScheduledEventsProfileArgsBuilder internal constructor() {
    private var osImageNotificationProfile: Output<OSImageNotificationProfileArgs>? = null

    private var terminateNotificationProfile: Output<TerminateNotificationProfileArgs>? = null

    /**
     * @param value Specifies OS Image Scheduled Event related configurations.
     */
    @JvmName("lsfkqkxtxyyeivmo")
    public suspend fun osImageNotificationProfile(`value`: Output<OSImageNotificationProfileArgs>) {
        this.osImageNotificationProfile = value
    }

    /**
     * @param value Specifies Terminate Scheduled Event related configurations.
     */
    @JvmName("etcnkjvbhfcfgbor")
    public suspend fun terminateNotificationProfile(`value`: Output<TerminateNotificationProfileArgs>) {
        this.terminateNotificationProfile = value
    }

    /**
     * @param value Specifies OS Image Scheduled Event related configurations.
     */
    @JvmName("kmiclxxkpiqfjwqa")
    public suspend fun osImageNotificationProfile(`value`: OSImageNotificationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osImageNotificationProfile = mapped
    }

    /**
     * @param argument Specifies OS Image Scheduled Event related configurations.
     */
    @JvmName("kgsbehpvmqloekmo")
    public suspend fun osImageNotificationProfile(argument: suspend OSImageNotificationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OSImageNotificationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osImageNotificationProfile = mapped
    }

    /**
     * @param value Specifies Terminate Scheduled Event related configurations.
     */
    @JvmName("knectdkdwtbgjjox")
    public suspend fun terminateNotificationProfile(`value`: TerminateNotificationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateNotificationProfile = mapped
    }

    /**
     * @param argument Specifies Terminate Scheduled Event related configurations.
     */
    @JvmName("fyujwgmeylpfoonj")
    public suspend fun terminateNotificationProfile(argument: suspend TerminateNotificationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = TerminateNotificationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.terminateNotificationProfile = mapped
    }

    internal fun build(): ScheduledEventsProfileArgs = ScheduledEventsProfileArgs(
        osImageNotificationProfile = osImageNotificationProfile,
        terminateNotificationProfile = terminateNotificationProfile,
    )
}
