@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.SecurityPostureReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01
 * @property excludeExtensions List of virtual machine extensions to exclude when applying the Security Posture.
 * @property id The security posture reference id in the form of /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest
 */
public data class SecurityPostureReferenceArgs(
    public val excludeExtensions: Output<List<VirtualMachineExtensionArgs>>? = null,
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.SecurityPostureReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.SecurityPostureReferenceArgs =
        com.pulumi.azurenative.azurefleet.inputs.SecurityPostureReferenceArgs.builder()
            .excludeExtensions(
                excludeExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityPostureReferenceArgs].
 */
@PulumiTagMarker
public class SecurityPostureReferenceArgsBuilder internal constructor() {
    private var excludeExtensions: Output<List<VirtualMachineExtensionArgs>>? = null

    private var id: Output<String>? = null

    /**
     * @param value List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("lcwlcobdwkwexcmj")
    public suspend fun excludeExtensions(`value`: Output<List<VirtualMachineExtensionArgs>>) {
        this.excludeExtensions = value
    }

    @JvmName("dtchcvlbuevdjtvu")
    public suspend fun excludeExtensions(vararg values: Output<VirtualMachineExtensionArgs>) {
        this.excludeExtensions = Output.all(values.asList())
    }

    /**
     * @param values List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("hmbmoivfdlfqlqgy")
    public suspend fun excludeExtensions(values: List<Output<VirtualMachineExtensionArgs>>) {
        this.excludeExtensions = Output.all(values)
    }

    /**
     * @param value The security posture reference id in the form of /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest
     */
    @JvmName("adrguaeqqjpacepx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("aaecqmaovtkacdor")
    public suspend fun excludeExtensions(`value`: List<VirtualMachineExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeExtensions = mapped
    }

    /**
     * @param argument List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("ugefbywkrawogmie")
    public suspend fun excludeExtensions(argument: List<suspend VirtualMachineExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.excludeExtensions = mapped
    }

    /**
     * @param argument List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("ytvogvtxvneasoxp")
    public suspend fun excludeExtensions(vararg argument: suspend VirtualMachineExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualMachineExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.excludeExtensions = mapped
    }

    /**
     * @param argument List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("xisiemcqifygwmjw")
    public suspend fun excludeExtensions(argument: suspend VirtualMachineExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineExtensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.excludeExtensions = mapped
    }

    /**
     * @param values List of virtual machine extensions to exclude when applying the Security Posture.
     */
    @JvmName("wtlciyuofoykvqug")
    public suspend fun excludeExtensions(vararg values: VirtualMachineExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludeExtensions = mapped
    }

    /**
     * @param value The security posture reference id in the form of /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest
     */
    @JvmName("pqrontlmxoxfbsec")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SecurityPostureReferenceArgs = SecurityPostureReferenceArgs(
        excludeExtensions = excludeExtensions,
        id = id,
    )
}
