@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.ServiceArtifactReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01
 * @property id The service artifact reference id in the form of /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}
 */
public data class ServiceArtifactReferenceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.ServiceArtifactReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.ServiceArtifactReferenceArgs =
        com.pulumi.azurenative.azurefleet.inputs.ServiceArtifactReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArtifactReferenceArgs].
 */
@PulumiTagMarker
public class ServiceArtifactReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The service artifact reference id in the form of /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}
     */
    @JvmName("qorglbhkdbaotqxe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The service artifact reference id in the form of /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}
     */
    @JvmName("lpvhtrgbjvjrtfak")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ServiceArtifactReferenceArgs = ServiceArtifactReferenceArgs(
        id = id,
    )
}
