@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.SpotPriorityProfileArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.EvictionPolicy
import com.pulumi.azurenative.azurefleet.kotlin.enums.SpotAllocationStrategy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration Options for Spot instances in Compute Fleet.
 * @property allocationStrategy Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
 * @property capacity Total capacity to achieve. It is currently in terms of number of VMs.
 * @property evictionPolicy Eviction Policy to follow when evicting Spot VMs.
 * @property maintain Flag to enable/disable continuous goal seeking for the desired capacity and restoration of evicted Spot VMs.
 * If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs (if VMs are evicted deleted)
 * or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate due to capacity constraint) in order to achieve the desired capacity.
 * Maintain is enabled by default.
 * @property maxPricePerVM Price per hour of each Spot VM will never exceed this.
 * @property minCapacity Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
 */
public data class SpotPriorityProfileArgs(
    public val allocationStrategy: Output<Either<String, SpotAllocationStrategy>>? = null,
    public val capacity: Output<Int>? = null,
    public val evictionPolicy: Output<Either<String, EvictionPolicy>>? = null,
    public val maintain: Output<Boolean>? = null,
    public val maxPricePerVM: Output<Double>? = null,
    public val minCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.SpotPriorityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.SpotPriorityProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.SpotPriorityProfileArgs.builder()
            .allocationStrategy(
                allocationStrategy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .evictionPolicy(
                evictionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maintain(maintain?.applyValue({ args0 -> args0 }))
            .maxPricePerVM(maxPricePerVM?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotPriorityProfileArgs].
 */
@PulumiTagMarker
public class SpotPriorityProfileArgsBuilder internal constructor() {
    private var allocationStrategy: Output<Either<String, SpotAllocationStrategy>>? = null

    private var capacity: Output<Int>? = null

    private var evictionPolicy: Output<Either<String, EvictionPolicy>>? = null

    private var maintain: Output<Boolean>? = null

    private var maxPricePerVM: Output<Double>? = null

    private var minCapacity: Output<Int>? = null

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
     */
    @JvmName("bxdkgxtsyqjwndpc")
    public suspend fun allocationStrategy(`value`: Output<Either<String, SpotAllocationStrategy>>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Total capacity to achieve. It is currently in terms of number of VMs.
     */
    @JvmName("vvylxawiwrddcxyw")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Eviction Policy to follow when evicting Spot VMs.
     */
    @JvmName("setqwipsdmwvwuou")
    public suspend fun evictionPolicy(`value`: Output<Either<String, EvictionPolicy>>) {
        this.evictionPolicy = value
    }

    /**
     * @param value Flag to enable/disable continuous goal seeking for the desired capacity and restoration of evicted Spot VMs.
     * If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs (if VMs are evicted deleted)
     * or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate due to capacity constraint) in order to achieve the desired capacity.
     * Maintain is enabled by default.
     */
    @JvmName("dyvumqjmlqwtjosa")
    public suspend fun maintain(`value`: Output<Boolean>) {
        this.maintain = value
    }

    /**
     * @param value Price per hour of each Spot VM will never exceed this.
     */
    @JvmName("scaqmbxgevfbftxu")
    public suspend fun maxPricePerVM(`value`: Output<Double>) {
        this.maxPricePerVM = value
    }

    /**
     * @param value Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
     */
    @JvmName("ghwsjajxbpikuvhu")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
     */
    @JvmName("ikbkmqxkjeadbvmh")
    public suspend fun allocationStrategy(`value`: Either<String, SpotAllocationStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
     */
    @JvmName("xiqeywygvhapioon")
    public fun allocationStrategy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SpotAllocationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
     */
    @JvmName("akcljciqptyawmgb")
    public fun allocationStrategy(`value`: SpotAllocationStrategy) {
        val toBeMapped = Either.ofRight<String, SpotAllocationStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Total capacity to achieve. It is currently in terms of number of VMs.
     */
    @JvmName("kwmlgliienttvjrt")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Eviction Policy to follow when evicting Spot VMs.
     */
    @JvmName("nbmcockwuhkoeunw")
    public suspend fun evictionPolicy(`value`: Either<String, EvictionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Eviction Policy to follow when evicting Spot VMs.
     */
    @JvmName("hyulsdyaxdcmywgg")
    public fun evictionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EvictionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Eviction Policy to follow when evicting Spot VMs.
     */
    @JvmName("jxklpfllmcdgqfho")
    public fun evictionPolicy(`value`: EvictionPolicy) {
        val toBeMapped = Either.ofRight<String, EvictionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Flag to enable/disable continuous goal seeking for the desired capacity and restoration of evicted Spot VMs.
     * If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs (if VMs are evicted deleted)
     * or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate due to capacity constraint) in order to achieve the desired capacity.
     * Maintain is enabled by default.
     */
    @JvmName("yglqeskoosikgofr")
    public suspend fun maintain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintain = mapped
    }

    /**
     * @param value Price per hour of each Spot VM will never exceed this.
     */
    @JvmName("mwwxajhwcemmdnyn")
    public suspend fun maxPricePerVM(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPricePerVM = mapped
    }

    /**
     * @param value Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
     */
    @JvmName("ehsdylucscxiadol")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): SpotPriorityProfileArgs = SpotPriorityProfileArgs(
        allocationStrategy = allocationStrategy,
        capacity = capacity,
        evictionPolicy = evictionPolicy,
        maintain = maintain,
        maxPricePerVM = maxPricePerVM,
        minCapacity = minCapacity,
    )
}
