@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VMGalleryApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the required information to reference a compute gallery application version
 * @property configurationReference Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided
 * @property enableAutomaticUpgrade If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated for the VM/VMSS
 * @property order Optional, Specifies the order in which the packages have to be installed
 * @property packageReferenceId Specifies the GalleryApplicationVersion resource id on the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
 * @property tags Optional, Specifies a passthrough value for more generic context.
 * @property treatFailureAsDeploymentFailure Optional, If true, any failure for any operation in the VmApplication will fail the deployment
 */
public data class VMGalleryApplicationArgs(
    public val configurationReference: Output<String>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val order: Output<Int>? = null,
    public val packageReferenceId: Output<String>,
    public val tags: Output<String>? = null,
    public val treatFailureAsDeploymentFailure: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VMGalleryApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VMGalleryApplicationArgs =
        com.pulumi.azurenative.azurefleet.inputs.VMGalleryApplicationArgs.builder()
            .configurationReference(configurationReference?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .order(order?.applyValue({ args0 -> args0 }))
            .packageReferenceId(packageReferenceId.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0 }))
            .treatFailureAsDeploymentFailure(
                treatFailureAsDeploymentFailure?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VMGalleryApplicationArgs].
 */
@PulumiTagMarker
public class VMGalleryApplicationArgsBuilder internal constructor() {
    private var configurationReference: Output<String>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var order: Output<Int>? = null

    private var packageReferenceId: Output<String>? = null

    private var tags: Output<String>? = null

    private var treatFailureAsDeploymentFailure: Output<Boolean>? = null

    /**
     * @param value Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided
     */
    @JvmName("aktxuqrqkocvoofn")
    public suspend fun configurationReference(`value`: Output<String>) {
        this.configurationReference = value
    }

    /**
     * @param value If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated for the VM/VMSS
     */
    @JvmName("amulvgrbqcbvruaf")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value Optional, Specifies the order in which the packages have to be installed
     */
    @JvmName("nyjwftgtudlajnwg")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value Specifies the GalleryApplicationVersion resource id on the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
     */
    @JvmName("mqquixqmijkfikas")
    public suspend fun packageReferenceId(`value`: Output<String>) {
        this.packageReferenceId = value
    }

    /**
     * @param value Optional, Specifies a passthrough value for more generic context.
     */
    @JvmName("pmwfrstjcdsucdor")
    public suspend fun tags(`value`: Output<String>) {
        this.tags = value
    }

    /**
     * @param value Optional, If true, any failure for any operation in the VmApplication will fail the deployment
     */
    @JvmName("hpuvbhpvkkcdmkqt")
    public suspend fun treatFailureAsDeploymentFailure(`value`: Output<Boolean>) {
        this.treatFailureAsDeploymentFailure = value
    }

    /**
     * @param value Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided
     */
    @JvmName("ijjcryoawvkdrxtg")
    public suspend fun configurationReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationReference = mapped
    }

    /**
     * @param value If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated for the VM/VMSS
     */
    @JvmName("bhylbuwsnejsrekd")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value Optional, Specifies the order in which the packages have to be installed
     */
    @JvmName("ykyjbvgdbglxehfs")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Specifies the GalleryApplicationVersion resource id on the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
     */
    @JvmName("paxcsbkuchharcpe")
    public suspend fun packageReferenceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageReferenceId = mapped
    }

    /**
     * @param value Optional, Specifies a passthrough value for more generic context.
     */
    @JvmName("ptcttsmctvxgiwok")
    public suspend fun tags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Optional, If true, any failure for any operation in the VmApplication will fail the deployment
     */
    @JvmName("bydmrakahmdfjchp")
    public suspend fun treatFailureAsDeploymentFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.treatFailureAsDeploymentFailure = mapped
    }

    internal fun build(): VMGalleryApplicationArgs = VMGalleryApplicationArgs(
        configurationReference = configurationReference,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        order = order,
        packageReferenceId = packageReferenceId ?: throw PulumiNullFieldException("packageReferenceId"),
        tags = tags,
        treatFailureAsDeploymentFailure = treatFailureAsDeploymentFailure,
    )
}
