@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VaultSecretGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a set of certificates which are all in the same Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
 * @property vaultCertificates The list of key vault references in SourceVault which contain certificates.
 */
public data class VaultSecretGroupArgs(
    public val sourceVault: Output<SubResourceArgs>? = null,
    public val vaultCertificates: Output<List<VaultCertificateArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VaultSecretGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VaultSecretGroupArgs =
        com.pulumi.azurenative.azurefleet.inputs.VaultSecretGroupArgs.builder()
            .sourceVault(sourceVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaultCertificates(
                vaultCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VaultSecretGroupArgs].
 */
@PulumiTagMarker
public class VaultSecretGroupArgsBuilder internal constructor() {
    private var sourceVault: Output<SubResourceArgs>? = null

    private var vaultCertificates: Output<List<VaultCertificateArgs>>? = null

    /**
     * @param value The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("wtwbaoxisbxdaieq")
    public suspend fun sourceVault(`value`: Output<SubResourceArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("cqhcjlsgrephegsj")
    public suspend fun vaultCertificates(`value`: Output<List<VaultCertificateArgs>>) {
        this.vaultCertificates = value
    }

    @JvmName("elkdanqagfvqotlr")
    public suspend fun vaultCertificates(vararg values: Output<VaultCertificateArgs>) {
        this.vaultCertificates = Output.all(values.asList())
    }

    /**
     * @param values The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("vcqcufsyodrxwecw")
    public suspend fun vaultCertificates(values: List<Output<VaultCertificateArgs>>) {
        this.vaultCertificates = Output.all(values)
    }

    /**
     * @param value The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("jeyngkwvcycmwygv")
    public suspend fun sourceVault(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     */
    @JvmName("lqqaibhjcskfiask")
    public suspend fun sourceVault(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    /**
     * @param value The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("eyiohlmgxgfuqpce")
    public suspend fun vaultCertificates(`value`: List<VaultCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("bljpkepbcaekebox")
    public suspend fun vaultCertificates(argument: List<suspend VaultCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VaultCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("vdehebmwxbyjjufu")
    public suspend fun vaultCertificates(vararg argument: suspend VaultCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VaultCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param argument The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("eyhqousvffeglmhy")
    public suspend fun vaultCertificates(argument: suspend VaultCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VaultCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vaultCertificates = mapped
    }

    /**
     * @param values The list of key vault references in SourceVault which contain certificates.
     */
    @JvmName("anmcdetvtrsttxbs")
    public suspend fun vaultCertificates(vararg values: VaultCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultCertificates = mapped
    }

    internal fun build(): VaultSecretGroupArgs = VaultSecretGroupArgs(
        sourceVault = sourceVault,
        vaultCertificates = vaultCertificates,
    )
}
