@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualHardDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the uri of a disk.
 * @property uri Specifies the virtual hard disk's uri.
 */
public data class VirtualHardDiskArgs(
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualHardDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualHardDiskArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualHardDiskArgs.builder()
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHardDiskArgs].
 */
@PulumiTagMarker
public class VirtualHardDiskArgsBuilder internal constructor() {
    private var uri: Output<String>? = null

    /**
     * @param value Specifies the virtual hard disk's uri.
     */
    @JvmName("oqqbojuerfyjlwvc")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Specifies the virtual hard disk's uri.
     */
    @JvmName("lfipkjusbqsgjcin")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): VirtualHardDiskArgs = VirtualHardDiskArgs(
        uri = uri,
    )
}
