@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineExtensionInstanceViewArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The instance view of a virtual machine extension.
 * @property name The virtual machine extension name.
 * @property statuses The resource status information.
 * @property substatuses The resource status information.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class VirtualMachineExtensionInstanceViewArgs(
    public val name: Output<String>? = null,
    public val statuses: Output<List<InstanceViewStatusArgs>>? = null,
    public val substatuses: Output<List<InstanceViewStatusArgs>>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineExtensionInstanceViewArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineExtensionInstanceViewArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineExtensionInstanceViewArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .statuses(
                statuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .substatuses(
                substatuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineExtensionInstanceViewArgs].
 */
@PulumiTagMarker
public class VirtualMachineExtensionInstanceViewArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var statuses: Output<List<InstanceViewStatusArgs>>? = null

    private var substatuses: Output<List<InstanceViewStatusArgs>>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value The virtual machine extension name.
     */
    @JvmName("kbqaecsaoitkxlah")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource status information.
     */
    @JvmName("uomeaywtdchkhhre")
    public suspend fun statuses(`value`: Output<List<InstanceViewStatusArgs>>) {
        this.statuses = value
    }

    @JvmName("peefkdyfosydhbbe")
    public suspend fun statuses(vararg values: Output<InstanceViewStatusArgs>) {
        this.statuses = Output.all(values.asList())
    }

    /**
     * @param values The resource status information.
     */
    @JvmName("rbrwpattbwsskkvk")
    public suspend fun statuses(values: List<Output<InstanceViewStatusArgs>>) {
        this.statuses = Output.all(values)
    }

    /**
     * @param value The resource status information.
     */
    @JvmName("erpkhsdrtscdthfq")
    public suspend fun substatuses(`value`: Output<List<InstanceViewStatusArgs>>) {
        this.substatuses = value
    }

    @JvmName("rbunuttvhpssvoxi")
    public suspend fun substatuses(vararg values: Output<InstanceViewStatusArgs>) {
        this.substatuses = Output.all(values.asList())
    }

    /**
     * @param values The resource status information.
     */
    @JvmName("kgkbabujfiroigjy")
    public suspend fun substatuses(values: List<Output<InstanceViewStatusArgs>>) {
        this.substatuses = Output.all(values)
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("elaanubmynnvufqq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("gigcsiqaavvfeihi")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value The virtual machine extension name.
     */
    @JvmName("laelbkmdqdfmjuuv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource status information.
     */
    @JvmName("lfuukjcmekjqyuqo")
    public suspend fun statuses(`value`: List<InstanceViewStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statuses = mapped
    }

    /**
     * @param argument The resource status information.
     */
    @JvmName("haafqbbhfwjhecey")
    public suspend fun statuses(argument: List<suspend InstanceViewStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceViewStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param argument The resource status information.
     */
    @JvmName("yxxmftmkdtbwokwd")
    public suspend fun statuses(vararg argument: suspend InstanceViewStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceViewStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param argument The resource status information.
     */
    @JvmName("qqviysqulphklbqi")
    public suspend fun statuses(argument: suspend InstanceViewStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceViewStatusArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param values The resource status information.
     */
    @JvmName("osminkhlljuadupk")
    public suspend fun statuses(vararg values: InstanceViewStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statuses = mapped
    }

    /**
     * @param value The resource status information.
     */
    @JvmName("rfxwgnvkxvflovsw")
    public suspend fun substatuses(`value`: List<InstanceViewStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.substatuses = mapped
    }

    /**
     * @param argument The resource status information.
     */
    @JvmName("ukxyakvkfvqigghy")
    public suspend fun substatuses(argument: List<suspend InstanceViewStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceViewStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.substatuses = mapped
    }

    /**
     * @param argument The resource status information.
     */
    @JvmName("trneefkhflvwmpcg")
    public suspend fun substatuses(vararg argument: suspend InstanceViewStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceViewStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.substatuses = mapped
    }

    /**
     * @param argument The resource status information.
     */
    @JvmName("mqoaowasohqcsyyv")
    public suspend fun substatuses(argument: suspend InstanceViewStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceViewStatusArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.substatuses = mapped
    }

    /**
     * @param values The resource status information.
     */
    @JvmName("hwydnuwojcpridoc")
    public suspend fun substatuses(vararg values: InstanceViewStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.substatuses = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("gerfostpaambdmip")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("bqhttxdhfghqyqpc")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): VirtualMachineExtensionInstanceViewArgs =
        VirtualMachineExtensionInstanceViewArgs(
            name = name,
            statuses = statuses,
            substatuses = substatuses,
            type = type,
            typeHandlerVersion = typeHandlerVersion,
        )
}
