@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetIpTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains the IP tag associated with the public IP address.
 * @property ipTagType IP tag type. Example: FirstPartyUsage.
 * @property tag IP tag associated with the public IP. Example: SQL, Storage etc.
 */
public data class VirtualMachineScaleSetIpTagArgs(
    public val ipTagType: Output<String>? = null,
    public val tag: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetIpTagArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetIpTagArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetIpTagArgs.builder()
            .ipTagType(ipTagType?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetIpTagArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetIpTagArgsBuilder internal constructor() {
    private var ipTagType: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value IP tag type. Example: FirstPartyUsage.
     */
    @JvmName("msrbmcrrgeljgqie")
    public suspend fun ipTagType(`value`: Output<String>) {
        this.ipTagType = value
    }

    /**
     * @param value IP tag associated with the public IP. Example: SQL, Storage etc.
     */
    @JvmName("ppcuwfsywdismjkb")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value IP tag type. Example: FirstPartyUsage.
     */
    @JvmName("yhdvijiosrqubqfo")
    public suspend fun ipTagType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTagType = mapped
    }

    /**
     * @param value IP tag associated with the public IP. Example: SQL, Storage etc.
     */
    @JvmName("iegwnotfluotdfal")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): VirtualMachineScaleSetIpTagArgs = VirtualMachineScaleSetIpTagArgs(
        ipTagType = ipTagType,
        tag = tag,
    )
}
