@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkConfigurationArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.DeleteOptions
import com.pulumi.azurenative.azurefleet.kotlin.enums.NetworkInterfaceAuxiliaryMode
import com.pulumi.azurenative.azurefleet.kotlin.enums.NetworkInterfaceAuxiliarySku
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set network profile's network configurations.
 * @property auxiliaryMode Specifies whether the Auxiliary mode is enabled for the Network Interface resource.
 * @property auxiliarySku Specifies whether the Auxiliary sku is enabled for the Network Interface resource.
 * @property deleteOption Specify what happens to the network interface when the VM is deleted
 * @property disableTcpStateTracking Specifies whether the network interface is disabled for tcp state tracking.
 * @property dnsSettings The dns settings to be applied on the network interfaces.
 * @property enableAcceleratedNetworking Specifies whether the network interface is accelerated networking-enabled.
 * @property enableFpga Specifies whether the network interface is FPGA networking-enabled.
 * @property enableIPForwarding Whether IP forwarding enabled on this NIC.
 * @property ipConfigurations Specifies the IP configurations of the network interface.
 * @property name The network configuration name.
 * @property networkSecurityGroup The network security group.
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 */
public data class VirtualMachineScaleSetNetworkConfigurationArgs(
    public val auxiliaryMode: Output<Either<String, NetworkInterfaceAuxiliaryMode>>? = null,
    public val auxiliarySku: Output<Either<String, NetworkInterfaceAuxiliarySku>>? = null,
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val disableTcpStateTracking: Output<Boolean>? = null,
    public val dnsSettings: Output<VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs>? = null,
    public val enableAcceleratedNetworking: Output<Boolean>? = null,
    public val enableFpga: Output<Boolean>? = null,
    public val enableIPForwarding: Output<Boolean>? = null,
    public val ipConfigurations: Output<List<VirtualMachineScaleSetIPConfigurationArgs>>,
    public val name: Output<String>,
    public val networkSecurityGroup: Output<SubResourceArgs>? = null,
    public val primary: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkConfigurationArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkConfigurationArgs.builder()
            .auxiliaryMode(
                auxiliaryMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .auxiliarySku(
                auxiliarySku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disableTcpStateTracking(disableTcpStateTracking?.applyValue({ args0 -> args0 }))
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableAcceleratedNetworking(enableAcceleratedNetworking?.applyValue({ args0 -> args0 }))
            .enableFpga(enableFpga?.applyValue({ args0 -> args0 }))
            .enableIPForwarding(enableIPForwarding?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .primary(primary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetNetworkConfigurationArgsBuilder internal constructor() {
    private var auxiliaryMode: Output<Either<String, NetworkInterfaceAuxiliaryMode>>? = null

    private var auxiliarySku: Output<Either<String, NetworkInterfaceAuxiliarySku>>? = null

    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var disableTcpStateTracking: Output<Boolean>? = null

    private var dnsSettings: Output<VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs>? = null

    private var enableAcceleratedNetworking: Output<Boolean>? = null

    private var enableFpga: Output<Boolean>? = null

    private var enableIPForwarding: Output<Boolean>? = null

    private var ipConfigurations: Output<List<VirtualMachineScaleSetIPConfigurationArgs>>? = null

    private var name: Output<String>? = null

    private var networkSecurityGroup: Output<SubResourceArgs>? = null

    private var primary: Output<Boolean>? = null

    /**
     * @param value Specifies whether the Auxiliary mode is enabled for the Network Interface resource.
     */
    @JvmName("iisurwcjqomudbqi")
    public suspend fun auxiliaryMode(`value`: Output<Either<String, NetworkInterfaceAuxiliaryMode>>) {
        this.auxiliaryMode = value
    }

    /**
     * @param value Specifies whether the Auxiliary sku is enabled for the Network Interface resource.
     */
    @JvmName("ukiiwmygltjpnopg")
    public suspend fun auxiliarySku(`value`: Output<Either<String, NetworkInterfaceAuxiliarySku>>) {
        this.auxiliarySku = value
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("gsxumaytuxkonpot")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value Specifies whether the network interface is disabled for tcp state tracking.
     */
    @JvmName("gqhdpjviiwuhmkgk")
    public suspend fun disableTcpStateTracking(`value`: Output<Boolean>) {
        this.disableTcpStateTracking = value
    }

    /**
     * @param value The dns settings to be applied on the network interfaces.
     */
    @JvmName("qryyuhahgccgfdrm")
    public suspend fun dnsSettings(`value`: Output<VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value Specifies whether the network interface is accelerated networking-enabled.
     */
    @JvmName("fadtlvpnteqabkow")
    public suspend fun enableAcceleratedNetworking(`value`: Output<Boolean>) {
        this.enableAcceleratedNetworking = value
    }

    /**
     * @param value Specifies whether the network interface is FPGA networking-enabled.
     */
    @JvmName("dgvwirtnqlvafmfn")
    public suspend fun enableFpga(`value`: Output<Boolean>) {
        this.enableFpga = value
    }

    /**
     * @param value Whether IP forwarding enabled on this NIC.
     */
    @JvmName("qrvvnotlxtrvbfra")
    public suspend fun enableIPForwarding(`value`: Output<Boolean>) {
        this.enableIPForwarding = value
    }

    /**
     * @param value Specifies the IP configurations of the network interface.
     */
    @JvmName("qqlqjjovqqebmnds")
    public suspend fun ipConfigurations(`value`: Output<List<VirtualMachineScaleSetIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("clftjtfvamsufauk")
    public suspend fun ipConfigurations(vararg values: Output<VirtualMachineScaleSetIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the IP configurations of the network interface.
     */
    @JvmName("phlnfjnrixkkvrvy")
    public suspend fun ipConfigurations(values: List<Output<VirtualMachineScaleSetIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The network configuration name.
     */
    @JvmName("cvlkcfjbcrsenruo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network security group.
     */
    @JvmName("hdgexdbdqughpuco")
    public suspend fun networkSecurityGroup(`value`: Output<SubResourceArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("aaaxgvouqfugrehj")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Specifies whether the Auxiliary mode is enabled for the Network Interface resource.
     */
    @JvmName("qdnncrijgxgusnjb")
    public suspend fun auxiliaryMode(`value`: Either<String, NetworkInterfaceAuxiliaryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auxiliaryMode = mapped
    }

    /**
     * @param value Specifies whether the Auxiliary mode is enabled for the Network Interface resource.
     */
    @JvmName("kvouqpgumxhdufqa")
    public fun auxiliaryMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkInterfaceAuxiliaryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliaryMode = mapped
    }

    /**
     * @param value Specifies whether the Auxiliary mode is enabled for the Network Interface resource.
     */
    @JvmName("lyefjsmnvxxlbpfj")
    public fun auxiliaryMode(`value`: NetworkInterfaceAuxiliaryMode) {
        val toBeMapped = Either.ofRight<String, NetworkInterfaceAuxiliaryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliaryMode = mapped
    }

    /**
     * @param value Specifies whether the Auxiliary sku is enabled for the Network Interface resource.
     */
    @JvmName("dfrqbloklottjwnp")
    public suspend fun auxiliarySku(`value`: Either<String, NetworkInterfaceAuxiliarySku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auxiliarySku = mapped
    }

    /**
     * @param value Specifies whether the Auxiliary sku is enabled for the Network Interface resource.
     */
    @JvmName("brajofvyyfhjrkmf")
    public fun auxiliarySku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkInterfaceAuxiliarySku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliarySku = mapped
    }

    /**
     * @param value Specifies whether the Auxiliary sku is enabled for the Network Interface resource.
     */
    @JvmName("xhhxvwlqjwhopwgt")
    public fun auxiliarySku(`value`: NetworkInterfaceAuxiliarySku) {
        val toBeMapped = Either.ofRight<String, NetworkInterfaceAuxiliarySku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliarySku = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("mmqfndclubrhhjck")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("tomrbsrgowoumytr")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("fgsgxmntfeebhwoj")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether the network interface is disabled for tcp state tracking.
     */
    @JvmName("mtnaxeedhsdthlae")
    public suspend fun disableTcpStateTracking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTcpStateTracking = mapped
    }

    /**
     * @param value The dns settings to be applied on the network interfaces.
     */
    @JvmName("tgpanttwywyxrila")
    public suspend fun dnsSettings(`value`: VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The dns settings to be applied on the network interfaces.
     */
    @JvmName("mymhujpvkonhjqnh")
    public suspend fun dnsSettings(argument: suspend VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value Specifies whether the network interface is accelerated networking-enabled.
     */
    @JvmName("bjpplqfndjtnushv")
    public suspend fun enableAcceleratedNetworking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceleratedNetworking = mapped
    }

    /**
     * @param value Specifies whether the network interface is FPGA networking-enabled.
     */
    @JvmName("irreihnffhadluuu")
    public suspend fun enableFpga(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFpga = mapped
    }

    /**
     * @param value Whether IP forwarding enabled on this NIC.
     */
    @JvmName("tpvwurysuehcgcel")
    public suspend fun enableIPForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIPForwarding = mapped
    }

    /**
     * @param value Specifies the IP configurations of the network interface.
     */
    @JvmName("ttnmipdxudururag")
    public suspend fun ipConfigurations(`value`: List<VirtualMachineScaleSetIPConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Specifies the IP configurations of the network interface.
     */
    @JvmName("vfopcsggdjrrdudr")
    public suspend fun ipConfigurations(argument: List<suspend VirtualMachineScaleSetIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Specifies the IP configurations of the network interface.
     */
    @JvmName("eylysmccqtbjvluw")
    public suspend fun ipConfigurations(vararg argument: suspend VirtualMachineScaleSetIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Specifies the IP configurations of the network interface.
     */
    @JvmName("cwfynqbgorrklkfp")
    public suspend fun ipConfigurations(argument: suspend VirtualMachineScaleSetIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineScaleSetIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values Specifies the IP configurations of the network interface.
     */
    @JvmName("slfiavhvsygmihul")
    public suspend fun ipConfigurations(vararg values: VirtualMachineScaleSetIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The network configuration name.
     */
    @JvmName("nrwssuxlhymaxoea")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network security group.
     */
    @JvmName("pvptuokladlrhhqc")
    public suspend fun networkSecurityGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument The network security group.
     */
    @JvmName("iwhsyaqyjctkhucc")
    public suspend fun networkSecurityGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("fuushjnckcpubgmd")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    internal fun build(): VirtualMachineScaleSetNetworkConfigurationArgs =
        VirtualMachineScaleSetNetworkConfigurationArgs(
            auxiliaryMode = auxiliaryMode,
            auxiliarySku = auxiliarySku,
            deleteOption = deleteOption,
            disableTcpStateTracking = disableTcpStateTracking,
            dnsSettings = dnsSettings,
            enableAcceleratedNetworking = enableAcceleratedNetworking,
            enableFpga = enableFpga,
            enableIPForwarding = enableIPForwarding,
            ipConfigurations = ipConfigurations ?: throw PulumiNullFieldException("ipConfigurations"),
            name = name ?: throw PulumiNullFieldException("name"),
            networkSecurityGroup = networkSecurityGroup,
            primary = primary,
        )
}
