@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkProfileArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.NetworkApiVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set network profile.
 * @property healthProbe A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
 * @property networkApiVersion specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
 * @property networkInterfaceConfigurations The list of network configurations.
 */
public data class VirtualMachineScaleSetNetworkProfileArgs(
    public val healthProbe: Output<ApiEntityReferenceArgs>? = null,
    public val networkApiVersion: Output<Either<String, NetworkApiVersion>>? = null,
    public val networkInterfaceConfigurations: Output<List<VirtualMachineScaleSetNetworkConfigurationArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetNetworkProfileArgs.builder()
            .healthProbe(healthProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkApiVersion(
                networkApiVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkInterfaceConfigurations(
                networkInterfaceConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineScaleSetNetworkProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetNetworkProfileArgsBuilder internal constructor() {
    private var healthProbe: Output<ApiEntityReferenceArgs>? = null

    private var networkApiVersion: Output<Either<String, NetworkApiVersion>>? = null

    private var networkInterfaceConfigurations:
        Output<List<VirtualMachineScaleSetNetworkConfigurationArgs>>? = null

    /**
     * @param value A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
     */
    @JvmName("iavdlglkxhniilmb")
    public suspend fun healthProbe(`value`: Output<ApiEntityReferenceArgs>) {
        this.healthProbe = value
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
     */
    @JvmName("kikfcstkyrtflruv")
    public suspend fun networkApiVersion(`value`: Output<Either<String, NetworkApiVersion>>) {
        this.networkApiVersion = value
    }

    /**
     * @param value The list of network configurations.
     */
    @JvmName("dmpyruswrhtdbqae")
    public suspend fun networkInterfaceConfigurations(`value`: Output<List<VirtualMachineScaleSetNetworkConfigurationArgs>>) {
        this.networkInterfaceConfigurations = value
    }

    @JvmName("sdissapjwhqlrjvb")
    public suspend fun networkInterfaceConfigurations(vararg values: Output<VirtualMachineScaleSetNetworkConfigurationArgs>) {
        this.networkInterfaceConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The list of network configurations.
     */
    @JvmName("oxbrnfnkdhqlffny")
    public suspend fun networkInterfaceConfigurations(values: List<Output<VirtualMachineScaleSetNetworkConfigurationArgs>>) {
        this.networkInterfaceConfigurations = Output.all(values)
    }

    /**
     * @param value A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
     */
    @JvmName("rknponvmudlifjgf")
    public suspend fun healthProbe(`value`: ApiEntityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbe = mapped
    }

    /**
     * @param argument A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
     */
    @JvmName("bneotbhdmkyvrfdf")
    public suspend fun healthProbe(argument: suspend ApiEntityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ApiEntityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthProbe = mapped
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
     */
    @JvmName("amegndhdtvgruqrt")
    public suspend fun networkApiVersion(`value`: Either<String, NetworkApiVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkApiVersion = mapped
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
     */
    @JvmName("aplgsqkrafhbgihd")
    public fun networkApiVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkApiVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkApiVersion = mapped
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'
     */
    @JvmName("hqxchplfhyfverra")
    public fun networkApiVersion(`value`: NetworkApiVersion) {
        val toBeMapped = Either.ofRight<String, NetworkApiVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkApiVersion = mapped
    }

    /**
     * @param value The list of network configurations.
     */
    @JvmName("umaedovqoqqeyurd")
    public suspend fun networkInterfaceConfigurations(`value`: List<VirtualMachineScaleSetNetworkConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument The list of network configurations.
     */
    @JvmName("gnjpbbuqxbfxwpvt")
    public suspend fun networkInterfaceConfigurations(argument: List<suspend VirtualMachineScaleSetNetworkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetNetworkConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument The list of network configurations.
     */
    @JvmName("ucdafdstmifjwvml")
    public suspend fun networkInterfaceConfigurations(vararg argument: suspend VirtualMachineScaleSetNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetNetworkConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument The list of network configurations.
     */
    @JvmName("ueduqwsiejqxvrsk")
    public suspend fun networkInterfaceConfigurations(argument: suspend VirtualMachineScaleSetNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineScaleSetNetworkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param values The list of network configurations.
     */
    @JvmName("vkephqyixqffifta")
    public suspend fun networkInterfaceConfigurations(vararg values: VirtualMachineScaleSetNetworkConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaceConfigurations = mapped
    }

    internal fun build(): VirtualMachineScaleSetNetworkProfileArgs =
        VirtualMachineScaleSetNetworkProfileArgs(
            healthProbe = healthProbe,
            networkApiVersion = networkApiVersion,
            networkInterfaceConfigurations = networkInterfaceConfigurations,
        )
}
