@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSDiskArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.CachingTypes
import com.pulumi.azurenative.azurefleet.kotlin.enums.DiskCreateOptionTypes
import com.pulumi.azurenative.azurefleet.kotlin.enums.DiskDeleteOptionTypes
import com.pulumi.azurenative.azurefleet.kotlin.enums.OperatingSystemTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set operating system disk.
 * @property caching Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
 * @property createOption Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
 * @property deleteOption Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
 * @property diffDiskSettings Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
 * @property diskSizeGB Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
 * @property image Specifies information about the unmanaged user image to base the scale set on.
 * @property managedDisk The managed disk parameters.
 * @property name The disk name.
 * @property osType This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 * @property vhdContainers Specifies the container urls that are used to store operating system disks for the scale set.
 * @property writeAcceleratorEnabled Specifies whether writeAccelerator should be enabled or disabled on the disk.
 */
public data class VirtualMachineScaleSetOSDiskArgs(
    public val caching: Output<CachingTypes>? = null,
    public val createOption: Output<Either<String, DiskCreateOptionTypes>>,
    public val deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null,
    public val diffDiskSettings: Output<DiffDiskSettingsArgs>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val image: Output<VirtualHardDiskArgs>? = null,
    public val managedDisk: Output<VirtualMachineScaleSetManagedDiskParametersArgs>? = null,
    public val name: Output<String>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val vhdContainers: Output<List<String>>? = null,
    public val writeAcceleratorEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSDiskArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSDiskArgs.builder()
            .caching(caching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createOption(
                createOption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diffDiskSettings(diffDiskSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vhdContainers(vhdContainers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .writeAcceleratorEnabled(writeAcceleratorEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetOSDiskArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetOSDiskArgsBuilder internal constructor() {
    private var caching: Output<CachingTypes>? = null

    private var createOption: Output<Either<String, DiskCreateOptionTypes>>? = null

    private var deleteOption: Output<Either<String, DiskDeleteOptionTypes>>? = null

    private var diffDiskSettings: Output<DiffDiskSettingsArgs>? = null

    private var diskSizeGB: Output<Int>? = null

    private var image: Output<VirtualHardDiskArgs>? = null

    private var managedDisk: Output<VirtualMachineScaleSetManagedDiskParametersArgs>? = null

    private var name: Output<String>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var vhdContainers: Output<List<String>>? = null

    private var writeAcceleratorEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("flxhhikvqhrqtgvi")
    public suspend fun caching(`value`: Output<CachingTypes>) {
        this.caching = value
    }

    /**
     * @param value Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
     */
    @JvmName("ahnieylkcacmsnvv")
    public suspend fun createOption(`value`: Output<Either<String, DiskCreateOptionTypes>>) {
        this.createOption = value
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
     */
    @JvmName("enkvlrfdetqwvyxy")
    public suspend fun deleteOption(`value`: Output<Either<String, DiskDeleteOptionTypes>>) {
        this.deleteOption = value
    }

    /**
     * @param value Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
     */
    @JvmName("tdpiuwqrsthmvfal")
    public suspend fun diffDiskSettings(`value`: Output<DiffDiskSettingsArgs>) {
        this.diffDiskSettings = value
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("qesbmwdnhubgjgqp")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Specifies information about the unmanaged user image to base the scale set on.
     */
    @JvmName("tsqcsdaeinlvpnes")
    public suspend fun image(`value`: Output<VirtualHardDiskArgs>) {
        this.image = value
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("vjxevfbcdyykltof")
    public suspend fun managedDisk(`value`: Output<VirtualMachineScaleSetManagedDiskParametersArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value The disk name.
     */
    @JvmName("bqcareqtytperouf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
     */
    @JvmName("qsbsunlanqljttth")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value Specifies the container urls that are used to store operating system disks for the scale set.
     */
    @JvmName("eisiufcdykxeaqre")
    public suspend fun vhdContainers(`value`: Output<List<String>>) {
        this.vhdContainers = value
    }

    @JvmName("rsueeqrtokpisehq")
    public suspend fun vhdContainers(vararg values: Output<String>) {
        this.vhdContainers = Output.all(values.asList())
    }

    /**
     * @param values Specifies the container urls that are used to store operating system disks for the scale set.
     */
    @JvmName("infwgkjnwlvjbddb")
    public suspend fun vhdContainers(values: List<Output<String>>) {
        this.vhdContainers = Output.all(values)
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("ktdjuxegyilbbqsm")
    public suspend fun writeAcceleratorEnabled(`value`: Output<Boolean>) {
        this.writeAcceleratorEnabled = value
    }

    /**
     * @param value Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**
     */
    @JvmName("iunfjbgblswsljlt")
    public suspend fun caching(`value`: CachingTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caching = mapped
    }

    /**
     * @param value Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
     */
    @JvmName("uedevopqpiotftpn")
    public suspend fun createOption(`value`: Either<String, DiskCreateOptionTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
     */
    @JvmName("xuxopsfykwlhmifm")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
     */
    @JvmName("abwqftiuyfcnainf")
    public fun createOption(`value`: DiskCreateOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskCreateOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
     */
    @JvmName("aiffbpkugettlhbu")
    public suspend fun deleteOption(`value`: Either<String, DiskDeleteOptionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
     */
    @JvmName("xwoiulvkkhfxblel")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
     */
    @JvmName("ttoyoqqwuhxsehtw")
    public fun deleteOption(`value`: DiskDeleteOptionTypes) {
        val toBeMapped = Either.ofRight<String, DiskDeleteOptionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
     */
    @JvmName("ufdkqodmmthbibbb")
    public suspend fun diffDiskSettings(`value`: DiffDiskSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diffDiskSettings = mapped
    }

    /**
     * @param argument Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
     */
    @JvmName("jbrtvpxutyddybbl")
    public suspend fun diffDiskSettings(argument: suspend DiffDiskSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DiffDiskSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diffDiskSettings = mapped
    }

    /**
     * @param value Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.
     */
    @JvmName("ckcebqiruicdkhwr")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Specifies information about the unmanaged user image to base the scale set on.
     */
    @JvmName("urtndbbdreopmwtv")
    public suspend fun image(`value`: VirtualHardDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument Specifies information about the unmanaged user image to base the scale set on.
     */
    @JvmName("fpnnjnfgrddftxjs")
    public suspend fun image(argument: suspend VirtualHardDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHardDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The managed disk parameters.
     */
    @JvmName("kovcqhwrsivvunfi")
    public suspend fun managedDisk(`value`: VirtualMachineScaleSetManagedDiskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument The managed disk parameters.
     */
    @JvmName("ucqagwusqdqbhmqb")
    public suspend fun managedDisk(argument: suspend VirtualMachineScaleSetManagedDiskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetManagedDiskParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    /**
     * @param value The disk name.
     */
    @JvmName("huqnkusvygvayrxy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
     */
    @JvmName("qhjbsbwdewkxhddk")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Specifies the container urls that are used to store operating system disks for the scale set.
     */
    @JvmName("yunoohhxqskmdqug")
    public suspend fun vhdContainers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdContainers = mapped
    }

    /**
     * @param values Specifies the container urls that are used to store operating system disks for the scale set.
     */
    @JvmName("vswkbntmxvomhgye")
    public suspend fun vhdContainers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vhdContainers = mapped
    }

    /**
     * @param value Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    @JvmName("wshpcslcdgwlyrmk")
    public suspend fun writeAcceleratorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeAcceleratorEnabled = mapped
    }

    internal fun build(): VirtualMachineScaleSetOSDiskArgs = VirtualMachineScaleSetOSDiskArgs(
        caching = caching,
        createOption = createOption ?: throw PulumiNullFieldException("createOption"),
        deleteOption = deleteOption,
        diffDiskSettings = diffDiskSettings,
        diskSizeGB = diskSizeGB,
        image = image,
        managedDisk = managedDisk,
        name = name,
        osType = osType,
        vhdContainers = vhdContainers,
        writeAcceleratorEnabled = writeAcceleratorEnabled,
    )
}
