@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set OS profile.
 * @property adminPassword Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
 * @property adminUsername Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
 * @property allowExtensionOperations Specifies whether extension operations should be allowed on the virtual machine scale set. This may only be set to False when no extensions are present on the virtual machine scale set.
 * @property computerNamePrefix Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
 * @property customData Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
 * @property linuxConfiguration Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
 * @property requireGuestProvisionSignal Optional property which must either be set to True or omitted.
 * @property secrets Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
 * @property windowsConfiguration Specifies Windows operating system settings on the virtual machine.
 */
public data class VirtualMachineScaleSetOSProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val allowExtensionOperations: Output<Boolean>? = null,
    public val computerNamePrefix: Output<String>? = null,
    public val customData: Output<String>? = null,
    public val linuxConfiguration: Output<LinuxConfigurationArgs>? = null,
    public val requireGuestProvisionSignal: Output<Boolean>? = null,
    public val secrets: Output<List<VaultSecretGroupArgs>>? = null,
    public val windowsConfiguration: Output<WindowsConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetOSProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .allowExtensionOperations(allowExtensionOperations?.applyValue({ args0 -> args0 }))
            .computerNamePrefix(computerNamePrefix?.applyValue({ args0 -> args0 }))
            .customData(customData?.applyValue({ args0 -> args0 }))
            .linuxConfiguration(
                linuxConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requireGuestProvisionSignal(requireGuestProvisionSignal?.applyValue({ args0 -> args0 }))
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .windowsConfiguration(
                windowsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineScaleSetOSProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetOSProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var allowExtensionOperations: Output<Boolean>? = null

    private var computerNamePrefix: Output<String>? = null

    private var customData: Output<String>? = null

    private var linuxConfiguration: Output<LinuxConfigurationArgs>? = null

    private var requireGuestProvisionSignal: Output<Boolean>? = null

    private var secrets: Output<List<VaultSecretGroupArgs>>? = null

    private var windowsConfiguration: Output<WindowsConfigurationArgs>? = null

    /**
     * @param value Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
     */
    @JvmName("olwybemlwjpvnmur")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
     */
    @JvmName("excrphprbdwetokh")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value Specifies whether extension operations should be allowed on the virtual machine scale set. This may only be set to False when no extensions are present on the virtual machine scale set.
     */
    @JvmName("sllqqtexntobnocb")
    public suspend fun allowExtensionOperations(`value`: Output<Boolean>) {
        this.allowExtensionOperations = value
    }

    /**
     * @param value Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
     */
    @JvmName("yqwmlidqwwsuaikx")
    public suspend fun computerNamePrefix(`value`: Output<String>) {
        this.computerNamePrefix = value
    }

    /**
     * @param value Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
     */
    @JvmName("hlaprycebnkubsck")
    public suspend fun customData(`value`: Output<String>) {
        this.customData = value
    }

    /**
     * @param value Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
     */
    @JvmName("dkjbesmgsgxjntgt")
    public suspend fun linuxConfiguration(`value`: Output<LinuxConfigurationArgs>) {
        this.linuxConfiguration = value
    }

    /**
     * @param value Optional property which must either be set to True or omitted.
     */
    @JvmName("gkydykcanvdeocon")
    public suspend fun requireGuestProvisionSignal(`value`: Output<Boolean>) {
        this.requireGuestProvisionSignal = value
    }

    /**
     * @param value Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("mxalqktdrkoxocit")
    public suspend fun secrets(`value`: Output<List<VaultSecretGroupArgs>>) {
        this.secrets = value
    }

    @JvmName("atjrlheaqegjipcr")
    public suspend fun secrets(vararg values: Output<VaultSecretGroupArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("ukgucuvjlqadnbxv")
    public suspend fun secrets(values: List<Output<VaultSecretGroupArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("aialclfjuhxxlacw")
    public suspend fun windowsConfiguration(`value`: Output<WindowsConfigurationArgs>) {
        this.windowsConfiguration = value
    }

    /**
     * @param value Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs&#46;microsoft&#46;com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
     */
    @JvmName("lnejhmqnrbqpycub")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters
     */
    @JvmName("hwhidyxrbvvqvcxr")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value Specifies whether extension operations should be allowed on the virtual machine scale set. This may only be set to False when no extensions are present on the virtual machine scale set.
     */
    @JvmName("cmuyrpjuajvdcorm")
    public suspend fun allowExtensionOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowExtensionOperations = mapped
    }

    /**
     * @param value Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
     */
    @JvmName("hcujpgbqirdejsmx")
    public suspend fun computerNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerNamePrefix = mapped
    }

    /**
     * @param value Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
     */
    @JvmName("hmaquepifpprehmr")
    public suspend fun customData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customData = mapped
    }

    /**
     * @param value Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
     */
    @JvmName("aukunjgaagnnqqvd")
    public suspend fun linuxConfiguration(`value`: LinuxConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxConfiguration = mapped
    }

    /**
     * @param argument Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
     */
    @JvmName("kwunalfibwurxrvm")
    public suspend fun linuxConfiguration(argument: suspend LinuxConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxConfiguration = mapped
    }

    /**
     * @param value Optional property which must either be set to True or omitted.
     */
    @JvmName("rykylttldyxexvks")
    public suspend fun requireGuestProvisionSignal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireGuestProvisionSignal = mapped
    }

    /**
     * @param value Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("adjjdgrgbwfrhvhx")
    public suspend fun secrets(`value`: List<VaultSecretGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("mjgwwacjowgeepim")
    public suspend fun secrets(argument: List<suspend VaultSecretGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VaultSecretGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("bsffsfqmrdkddrvf")
    public suspend fun secrets(vararg argument: suspend VaultSecretGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VaultSecretGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("jevcwqwgsloyqoce")
    public suspend fun secrets(argument: suspend VaultSecretGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VaultSecretGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs&#46;microsoft&#46;com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
     */
    @JvmName("xykqqeifdffkprqd")
    public suspend fun secrets(vararg values: VaultSecretGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("uctmkhuvaandetem")
    public suspend fun windowsConfiguration(`value`: WindowsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsConfiguration = mapped
    }

    /**
     * @param argument Specifies Windows operating system settings on the virtual machine.
     */
    @JvmName("klfjgnrxusnbirui")
    public suspend fun windowsConfiguration(argument: suspend WindowsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsConfiguration = mapped
    }

    internal fun build(): VirtualMachineScaleSetOSProfileArgs = VirtualMachineScaleSetOSProfileArgs(
        adminPassword = adminPassword,
        adminUsername = adminUsername,
        allowExtensionOperations = allowExtensionOperations,
        computerNamePrefix = computerNamePrefix,
        customData = customData,
        linuxConfiguration = linuxConfiguration,
        requireGuestProvisionSignal = requireGuestProvisionSignal,
        secrets = secrets,
        windowsConfiguration = windowsConfiguration,
    )
}
