@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.DomainNameLabelScopeTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 * @property domainNameLabel The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 * @property domainNameLabelScope The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 */
public data class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs(
    public val domainNameLabel: Output<String>,
    public val domainNameLabelScope: Output<Either<String, DomainNameLabelScopeTypes>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs =
        com.pulumi.azurenative.azurefleet.inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs.builder()
            .domainNameLabel(domainNameLabel.applyValue({ args0 -> args0 }))
            .domainNameLabelScope(
                domainNameLabelScope?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgsBuilder internal constructor() {
    private var domainNameLabel: Output<String>? = null

    private var domainNameLabelScope: Output<Either<String, DomainNameLabelScopeTypes>>? = null

    /**
     * @param value The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("bxhipanyeqqjulmx")
    public suspend fun domainNameLabel(`value`: Output<String>) {
        this.domainNameLabel = value
    }

    /**
     * @param value The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("vcegawgdmusqqpyj")
    public suspend fun domainNameLabelScope(`value`: Output<Either<String, DomainNameLabelScopeTypes>>) {
        this.domainNameLabelScope = value
    }

    /**
     * @param value The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("ngvqcadstnvxobia")
    public suspend fun domainNameLabel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNameLabel = mapped
    }

    /**
     * @param value The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("mcbfmynwrdrbuafw")
    public suspend fun domainNameLabelScope(`value`: Either<String, DomainNameLabelScopeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameLabelScope = mapped
    }

    /**
     * @param value The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("avjnhpyrjbccxmju")
    public fun domainNameLabelScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DomainNameLabelScopeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNameLabelScope = mapped
    }

    /**
     * @param value The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
     */
    @JvmName("rpgdnlasxfegilis")
    public fun domainNameLabelScope(`value`: DomainNameLabelScopeTypes) {
        val toBeMapped = Either.ofRight<String, DomainNameLabelScopeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNameLabelScope = mapped
    }

    internal fun build(): VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs =
        VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs(
            domainNameLabel = domainNameLabel ?: throw PulumiNullFieldException("domainNameLabel"),
            domainNameLabelScope = domainNameLabelScope,
        )
}
