@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.VmSizeProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifications about a VM Size. This will also contain the corresponding rank and weight in future.
 * @property name The Sku name (e.g. 'Standard_DS1_v2')
 * @property rank The rank of the VM size. This is used with 'RegularPriorityAllocationStrategy.Prioritized'
 * The lower the number, the higher the priority. Starting with 0.
 */
public data class VmSizeProfileArgs(
    public val name: Output<String>,
    public val rank: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.VmSizeProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.VmSizeProfileArgs =
        com.pulumi.azurenative.azurefleet.inputs.VmSizeProfileArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .rank(rank?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmSizeProfileArgs].
 */
@PulumiTagMarker
public class VmSizeProfileArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var rank: Output<Int>? = null

    /**
     * @param value The Sku name (e.g. 'Standard_DS1_v2')
     */
    @JvmName("qxbhxnjpdfiooipc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rank of the VM size. This is used with 'RegularPriorityAllocationStrategy.Prioritized'
     * The lower the number, the higher the priority. Starting with 0.
     */
    @JvmName("ilxbmnpbakgxrxwn")
    public suspend fun rank(`value`: Output<Int>) {
        this.rank = value
    }

    /**
     * @param value The Sku name (e.g. 'Standard_DS1_v2')
     */
    @JvmName("mfiadyiwruyrvmlj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The rank of the VM size. This is used with 'RegularPriorityAllocationStrategy.Prioritized'
     * The lower the number, the higher the priority. Starting with 0.
     */
    @JvmName("gkdylhaotipikpwq")
    public suspend fun rank(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rank = mapped
    }

    internal fun build(): VmSizeProfileArgs = VmSizeProfileArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        rank = rank,
    )
}
