@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.inputs

import com.pulumi.azurenative.azurefleet.inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.enums.WindowsVMGuestPatchAutomaticByPlatformRebootSetting
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies additional settings to be applied when patch mode AutomaticByPlatform is selected in Windows patch settings.
 * @property bypassPlatformSafetyChecksOnUserSchedule Enables customer to schedule patching without accidental upgrades
 * @property rebootSetting Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
 */
public data class WindowsVMGuestPatchAutomaticByPlatformSettingsArgs(
    public val bypassPlatformSafetyChecksOnUserSchedule: Output<Boolean>? = null,
    public val rebootSetting: Output<Either<String, WindowsVMGuestPatchAutomaticByPlatformRebootSetting>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurefleet.inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs =
        com.pulumi.azurenative.azurefleet.inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs.builder()
            .bypassPlatformSafetyChecksOnUserSchedule(
                bypassPlatformSafetyChecksOnUserSchedule?.applyValue({ args0 ->
                    args0
                }),
            )
            .rebootSetting(
                rebootSetting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WindowsVMGuestPatchAutomaticByPlatformSettingsArgs].
 */
@PulumiTagMarker
public class WindowsVMGuestPatchAutomaticByPlatformSettingsArgsBuilder internal constructor() {
    private var bypassPlatformSafetyChecksOnUserSchedule: Output<Boolean>? = null

    private var rebootSetting:
        Output<Either<String, WindowsVMGuestPatchAutomaticByPlatformRebootSetting>>? = null

    /**
     * @param value Enables customer to schedule patching without accidental upgrades
     */
    @JvmName("vtrvpnykwsjkxlyb")
    public suspend fun bypassPlatformSafetyChecksOnUserSchedule(`value`: Output<Boolean>) {
        this.bypassPlatformSafetyChecksOnUserSchedule = value
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("yifspnwcbscwcoiu")
    public suspend fun rebootSetting(`value`: Output<Either<String, WindowsVMGuestPatchAutomaticByPlatformRebootSetting>>) {
        this.rebootSetting = value
    }

    /**
     * @param value Enables customer to schedule patching without accidental upgrades
     */
    @JvmName("hilfecjrwceukvrq")
    public suspend fun bypassPlatformSafetyChecksOnUserSchedule(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPlatformSafetyChecksOnUserSchedule = mapped
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("ffdtocptwdwgranw")
    public suspend fun rebootSetting(`value`: Either<String, WindowsVMGuestPatchAutomaticByPlatformRebootSetting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("udwvtvsjntsajvfi")
    public fun rebootSetting(`value`: String) {
        val toBeMapped = Either.ofLeft<
            String,
            WindowsVMGuestPatchAutomaticByPlatformRebootSetting,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    /**
     * @param value Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
     */
    @JvmName("uwdgdbpxpccvoukk")
    public fun rebootSetting(`value`: WindowsVMGuestPatchAutomaticByPlatformRebootSetting) {
        val toBeMapped = Either.ofRight<
            String,
            WindowsVMGuestPatchAutomaticByPlatformRebootSetting,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rebootSetting = mapped
    }

    internal fun build(): WindowsVMGuestPatchAutomaticByPlatformSettingsArgs =
        WindowsVMGuestPatchAutomaticByPlatformSettingsArgs(
            bypassPlatformSafetyChecksOnUserSchedule = bypassPlatformSafetyChecksOnUserSchedule,
            rebootSetting = rebootSetting,
        )
}
