@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains the list of gallery applications that should be made available to the VM/VMSS
 * @property galleryApplications Specifies the gallery applications that should be made available to the VM/VMSS
 */
public data class ApplicationProfileResponse(
    public val galleryApplications: List<VMGalleryApplicationResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.ApplicationProfileResponse): ApplicationProfileResponse = ApplicationProfileResponse(
            galleryApplications = javaType.galleryApplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.VMGalleryApplicationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
