@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Suppress

/**
 * The parameters of a capacity reservation Profile.
 * @property capacityReservationGroup Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.
 */
public data class CapacityReservationProfileResponse(
    public val capacityReservationGroup: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.CapacityReservationProfileResponse): CapacityReservationProfileResponse = CapacityReservationProfileResponse(
            capacityReservationGroup = javaType.capacityReservationGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
