@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Compute Profile to use for running user's workloads.
 * @property baseVirtualMachineProfile Base Virtual Machine Profile Properties to be specified according to "specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile"
 * @property computeApiVersion Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machine scale sets and Virtual Machines.
 * The default value will be the latest supported computeApiVersion by Compute Fleet.
 * @property platformFaultDomainCount Specifies the number of fault domains to use when creating the underlying VMSS.
 * A fault domain is a logical group of hardware within an Azure datacenter.
 * VMs in the same fault domain share a common power source and network switch.
 * If not specified, defaults to 1, which represents "Max Spreading" (using as many fault domains as possible).
 * This property cannot be updated.
 */
public data class ComputeProfileResponse(
    public val baseVirtualMachineProfile: VirtualMachineScaleSetVMProfileResponse,
    public val computeApiVersion: String? = null,
    public val platformFaultDomainCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.ComputeProfileResponse): ComputeProfileResponse = ComputeProfileResponse(
            baseVirtualMachineProfile = javaType.baseVirtualMachineProfile().let({ args0 ->
                com.pulumi.azurenative.azurefleet.kotlin.outputs.VirtualMachineScaleSetVMProfileResponse.Companion.toKotlin(args0)
            }),
            computeApiVersion = javaType.computeApiVersion().map({ args0 -> args0 }).orElse(null),
            platformFaultDomainCount = javaType.platformFaultDomainCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
