@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Suppress

/**
 * Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property bootDiagnostics Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.
 */
public data class DiagnosticsProfileResponse(
    public val bootDiagnostics: BootDiagnosticsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.DiagnosticsProfileResponse): DiagnosticsProfileResponse = DiagnosticsProfileResponse(
            bootDiagnostics = javaType.bootDiagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.BootDiagnosticsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
