@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the Managed Identity used by ADE to get access token for keyvault operations.
 * @property userAssignedIdentityResourceId Specifies ARM Resource ID of one of the user identities associated with the VM.
 */
public data class EncryptionIdentityResponse(
    public val userAssignedIdentityResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.EncryptionIdentityResponse): EncryptionIdentityResponse = EncryptionIdentityResponse(
            userAssignedIdentityResourceId = javaType.userAssignedIdentityResourceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
