@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Compute Fleet resource
 * @property computeProfile Compute Profile to use for running user's workloads.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property plan Details of the resource plan.
 * @property provisioningState The status of the last operation.
 * @property regularPriorityProfile Configuration Options for Regular instances in Compute Fleet.
 * @property spotPriorityProfile Configuration Options for Spot instances in Compute Fleet.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmSizesProfile List of VM sizes supported for Compute Fleet
 * @property zones Zones in which the Compute Fleet is available
 */
public data class GetFleetResult(
    public val computeProfile: ComputeProfileResponse,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val plan: PlanResponse? = null,
    public val provisioningState: String,
    public val regularPriorityProfile: RegularPriorityProfileResponse? = null,
    public val spotPriorityProfile: SpotPriorityProfileResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmSizesProfile: List<VmSizeProfileResponse>,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.GetFleetResult): GetFleetResult = GetFleetResult(
            computeProfile = javaType.computeProfile().let({ args0 ->
                com.pulumi.azurenative.azurefleet.kotlin.outputs.ComputeProfileResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            regularPriorityProfile = javaType.regularPriorityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.RegularPriorityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spotPriorityProfile = javaType.spotPriorityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.SpotPriorityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurefleet.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmSizesProfile = javaType.vmSizesProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.VmSizeProfileResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
