@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
 * @property communityGalleryImageId Specified the community gallery image unique id for vm deployment. This can be fetched from community gallery image GET call.
 * @property exactVersion Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual machine. This readonly field differs from 'version', only if the value specified in 'version' field is 'latest'.
 * @property id Resource Id
 * @property offer Specifies the offer of the platform image or marketplace image used to create the virtual machine.
 * @property publisher The image publisher.
 * @property sharedGalleryImageId Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
 * @property sku The image SKU.
 * @property version Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available. Please do not use field 'version' for gallery image deployment, gallery image should always use 'id' field for deployment, to use 'latest' version of gallery image, just set '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}' in the 'id' field without version input.
 */
public data class ImageReferenceResponse(
    public val communityGalleryImageId: String? = null,
    public val exactVersion: String,
    public val id: String? = null,
    public val offer: String? = null,
    public val publisher: String? = null,
    public val sharedGalleryImageId: String? = null,
    public val sku: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.ImageReferenceResponse): ImageReferenceResponse = ImageReferenceResponse(
            communityGalleryImageId = javaType.communityGalleryImageId().map({ args0 -> args0 }).orElse(null),
            exactVersion = javaType.exactVersion(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            sharedGalleryImageId = javaType.sharedGalleryImageId().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
