@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enable Specifies whether the OS Image Scheduled event is enabled or disabled.
 * @property notBeforeTimeout Length of time a Virtual Machine being reimaged or having its OS upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto approved (timed out). The configuration is specified in ISO 8601 format, and the value must be 15 minutes (PT15M)
 */
public data class OSImageNotificationProfileResponse(
    public val enable: Boolean? = null,
    public val notBeforeTimeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.OSImageNotificationProfileResponse): OSImageNotificationProfileResponse = OSImageNotificationProfileResponse(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            notBeforeTimeout = javaType.notBeforeTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
