@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies ProxyAgent settings while creating the virtual machine. Minimum api-version: 2023-09-01.
 * @property enabled Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.
 * @property keyIncarnationId Increase the value of this property allows user to reset the key used for securing communication channel between guest and host.
 * @property mode Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
 */
public data class ProxyAgentSettingsResponse(
    public val enabled: Boolean? = null,
    public val keyIncarnationId: Int? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.ProxyAgentSettingsResponse): ProxyAgentSettingsResponse = ProxyAgentSettingsResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            keyIncarnationId = javaType.keyIncarnationId().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
