@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
 * @property name Specify public IP sku name
 * @property tier Specify public IP sku tier
 */
public data class PublicIPAddressSkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.PublicIPAddressSkuResponse): PublicIPAddressSkuResponse = PublicIPAddressSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
