@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Configuration Options for Regular instances in Compute Fleet.
 * @property allocationStrategy Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
 * @property capacity Total capacity to achieve. It is currently in terms of number of VMs.
 * @property minCapacity Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
 */
public data class RegularPriorityProfileResponse(
    public val allocationStrategy: String? = null,
    public val capacity: Int? = null,
    public val minCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.RegularPriorityProfileResponse): RegularPriorityProfileResponse = RegularPriorityProfileResponse(
            allocationStrategy = javaType.allocationStrategy().map({ args0 -> args0 }).orElse(null),
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
