@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Configuration Options for Spot instances in Compute Fleet.
 * @property allocationStrategy Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
 * @property capacity Total capacity to achieve. It is currently in terms of number of VMs.
 * @property evictionPolicy Eviction Policy to follow when evicting Spot VMs.
 * @property maintain Flag to enable/disable continuous goal seeking for the desired capacity and restoration of evicted Spot VMs.
 * If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs (if VMs are evicted deleted)
 * or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate due to capacity constraint) in order to achieve the desired capacity.
 * Maintain is enabled by default.
 * @property maxPricePerVM Price per hour of each Spot VM will never exceed this.
 * @property minCapacity Minimum capacity to achieve which cannot be updated. If we will not be able to "guarantee" minimum capacity, we will reject the request in the sync path itself.
 */
public data class SpotPriorityProfileResponse(
    public val allocationStrategy: String? = null,
    public val capacity: Int? = null,
    public val evictionPolicy: String? = null,
    public val maintain: Boolean? = null,
    public val maxPricePerVM: Double? = null,
    public val minCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.SpotPriorityProfileResponse): SpotPriorityProfileResponse = SpotPriorityProfileResponse(
            allocationStrategy = javaType.allocationStrategy().map({ args0 -> args0 }).orElse(null),
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            evictionPolicy = javaType.evictionPolicy().map({ args0 -> args0 }).orElse(null),
            maintain = javaType.maintain().map({ args0 -> args0 }).orElse(null),
            maxPricePerVM = javaType.maxPricePerVM().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
