@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the security profile settings for the managed disk. **Note:** It can only be set for Confidential VMs.
 * @property diskEncryptionSet Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.
 * @property securityEncryptionType Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob.. **Note:** It can be set for only Confidential VMs.
 */
public data class VMDiskSecurityProfileResponse(
    public val diskEncryptionSet: DiskEncryptionSetParametersResponse? = null,
    public val securityEncryptionType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VMDiskSecurityProfileResponse): VMDiskSecurityProfileResponse = VMDiskSecurityProfileResponse(
            diskEncryptionSet = javaType.diskEncryptionSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.DiskEncryptionSetParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityEncryptionType = javaType.securityEncryptionType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
