@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Specifies VM Size Property settings on the virtual machine.
 * @property vCPUsAvailable Specifies the number of vCPUs available for the VM. When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list).
 * @property vCPUsPerCore Specifies the vCPU to physical core ratio. When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list). **Setting this property to 1 also means that hyper-threading is disabled.**
 */
public data class VMSizePropertiesResponse(
    public val vCPUsAvailable: Int? = null,
    public val vCPUsPerCore: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VMSizePropertiesResponse): VMSizePropertiesResponse = VMSizePropertiesResponse(
            vCPUsAvailable = javaType.vCPUsAvailable().map({ args0 -> args0 }).orElse(null),
            vCPUsPerCore = javaType.vCPUsPerCore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
