@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a set of certificates which are all in the same Key Vault.
 * @property sourceVault The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
 * @property vaultCertificates The list of key vault references in SourceVault which contain certificates.
 */
public data class VaultSecretGroupResponse(
    public val sourceVault: SubResourceResponse? = null,
    public val vaultCertificates: List<VaultCertificateResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VaultSecretGroupResponse): VaultSecretGroupResponse = VaultSecretGroupResponse(
            sourceVault = javaType.sourceVault().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vaultCertificates = javaType.vaultCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.VaultCertificateResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
