@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the parameters of a ScaleSet managed disk.
 * @property diskEncryptionSet Specifies the customer managed disk encryption set resource id for the managed disk.
 * @property securityProfile Specifies the security profile for the managed disk.
 * @property storageAccountType Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
 */
public data class VirtualMachineScaleSetManagedDiskParametersResponse(
    public val diskEncryptionSet: DiskEncryptionSetParametersResponse? = null,
    public val securityProfile: VMDiskSecurityProfileResponse? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VirtualMachineScaleSetManagedDiskParametersResponse): VirtualMachineScaleSetManagedDiskParametersResponse =
            VirtualMachineScaleSetManagedDiskParametersResponse(
                diskEncryptionSet = javaType.diskEncryptionSet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurefleet.kotlin.outputs.DiskEncryptionSetParametersResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                securityProfile = javaType.securityProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurefleet.kotlin.outputs.VMDiskSecurityProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
