@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a virtual machine scale set network profile's network configurations.
 * @property auxiliaryMode Specifies whether the Auxiliary mode is enabled for the Network Interface resource.
 * @property auxiliarySku Specifies whether the Auxiliary sku is enabled for the Network Interface resource.
 * @property deleteOption Specify what happens to the network interface when the VM is deleted
 * @property disableTcpStateTracking Specifies whether the network interface is disabled for tcp state tracking.
 * @property dnsSettings The dns settings to be applied on the network interfaces.
 * @property enableAcceleratedNetworking Specifies whether the network interface is accelerated networking-enabled.
 * @property enableFpga Specifies whether the network interface is FPGA networking-enabled.
 * @property enableIPForwarding Whether IP forwarding enabled on this NIC.
 * @property ipConfigurations Specifies the IP configurations of the network interface.
 * @property name The network configuration name.
 * @property networkSecurityGroup The network security group.
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 */
public data class VirtualMachineScaleSetNetworkConfigurationResponse(
    public val auxiliaryMode: String? = null,
    public val auxiliarySku: String? = null,
    public val deleteOption: String? = null,
    public val disableTcpStateTracking: Boolean? = null,
    public val dnsSettings: VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse? = null,
    public val enableAcceleratedNetworking: Boolean? = null,
    public val enableFpga: Boolean? = null,
    public val enableIPForwarding: Boolean? = null,
    public val ipConfigurations: List<VirtualMachineScaleSetIPConfigurationResponse>,
    public val name: String,
    public val networkSecurityGroup: SubResourceResponse? = null,
    public val primary: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VirtualMachineScaleSetNetworkConfigurationResponse): VirtualMachineScaleSetNetworkConfigurationResponse =
            VirtualMachineScaleSetNetworkConfigurationResponse(
                auxiliaryMode = javaType.auxiliaryMode().map({ args0 -> args0 }).orElse(null),
                auxiliarySku = javaType.auxiliarySku().map({ args0 -> args0 }).orElse(null),
                deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
                disableTcpStateTracking = javaType.disableTcpStateTracking().map({ args0 -> args0 }).orElse(null),
                dnsSettings = javaType.dnsSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurefleet.kotlin.outputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enableAcceleratedNetworking = javaType.enableAcceleratedNetworking().map({ args0 ->
                    args0
                }).orElse(null),
                enableFpga = javaType.enableFpga().map({ args0 -> args0 }).orElse(null),
                enableIPForwarding = javaType.enableIPForwarding().map({ args0 -> args0 }).orElse(null),
                ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurefleet.kotlin.outputs.VirtualMachineScaleSetIPConfigurationResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                networkSecurityGroup = javaType.networkSecurityGroup().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurefleet.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
            )
    }
}
