@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 * @property domainNameLabel The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 * @property domainNameLabelScope The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 */
public data class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse(
    public val domainNameLabel: String,
    public val domainNameLabelScope: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse): VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse =
            VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse(
                domainNameLabel = javaType.domainNameLabel(),
                domainNameLabelScope = javaType.domainNameLabelScope().map({ args0 -> args0 }).orElse(null),
            )
    }
}
