@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifications about a VM Size. This will also contain the corresponding rank and weight in future.
 * @property name The Sku name (e.g. 'Standard_DS1_v2')
 * @property rank The rank of the VM size. This is used with 'RegularPriorityAllocationStrategy.Prioritized'
 * The lower the number, the higher the priority. Starting with 0.
 */
public data class VmSizeProfileResponse(
    public val name: String,
    public val rank: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.VmSizeProfileResponse): VmSizeProfileResponse = VmSizeProfileResponse(
            name = javaType.name(),
            rank = javaType.rank().map({ args0 -> args0 }).orElse(null),
        )
    }
}
