@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies Windows operating system settings on the virtual machine.
 * @property additionalUnattendContent Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
 * @property enableAutomaticUpdates Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
 * @property enableVMAgentPlatformUpdates Indicates whether VMAgent Platform Updates is enabled for the Windows virtual machine. Default value is false.
 * @property patchSettings [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
 * @property provisionVMAgent Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, it is set to true by default. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
 * @property timeZone Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". Possible values can be [TimeZoneInfo&#46;Id](https://docs&#46;microsoft&#46;com/dotnet/api/system&#46;timezoneinfo&#46;id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo&#46;GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).
 * @property winRM Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
 */
public data class WindowsConfigurationResponse(
    public val additionalUnattendContent: List<AdditionalUnattendContentResponse>? = null,
    public val enableAutomaticUpdates: Boolean? = null,
    public val enableVMAgentPlatformUpdates: Boolean? = null,
    public val patchSettings: PatchSettingsResponse? = null,
    public val provisionVMAgent: Boolean? = null,
    public val timeZone: String? = null,
    public val winRM: WinRMConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.outputs.WindowsConfigurationResponse): WindowsConfigurationResponse = WindowsConfigurationResponse(
            additionalUnattendContent = javaType.additionalUnattendContent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.AdditionalUnattendContentResponse.Companion.toKotlin(args0)
                })
            }),
            enableAutomaticUpdates = javaType.enableAutomaticUpdates().map({ args0 -> args0 }).orElse(null),
            enableVMAgentPlatformUpdates = javaType.enableVMAgentPlatformUpdates().map({ args0 ->
                args0
            }).orElse(null),
            patchSettings = javaType.patchSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.PatchSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisionVMAgent = javaType.provisionVMAgent().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            winRM = javaType.winRM().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurefleet.kotlin.outputs.WinRMConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
